package io.embrace.android.embracesdk.networking

import com.google.gson.TypeAdapter
import com.google.gson.stream.JsonReader
import com.google.gson.stream.JsonWriter
import io.embrace.android.embracesdk.InternalApi

@InternalApi
public class EmbraceUrlAdapter : TypeAdapter<EmbraceUrl>() {

    override fun write(jsonWriter: JsonWriter, embraceUrl: EmbraceUrl?) {
        jsonWriter?.let {
            it.beginObject()
            it.name("url").value(embraceUrl?.toString())
            it.endObject()
        }
    }

    override fun read(jsonReader: JsonReader): EmbraceUrl? {
        var embraceUrl: EmbraceUrl? = null

        jsonReader.beginObject()
        while (jsonReader.hasNext()) {
            if (jsonReader.nextName() == "url") {
                embraceUrl = EmbraceUrl.getUrl(jsonReader.nextString())
            }
        }
        jsonReader.endObject()

        return embraceUrl
    }
}
