package io.embrace.android.embracesdk.utils;

import android.os.Handler;
import android.os.Looper;

import io.embrace.android.embracesdk.InternalApi;
import io.embrace.android.embracesdk.logging.InternalStaticEmbraceLogger;

@InternalApi
public class ThreadUtils {

    private static final Looper mainLooper = Looper.getMainLooper();
    private static final Thread mainThread = mainLooper.getThread();

    public static void runOnMainThread(Runnable runnable) {
        if (runnable == null) {
            return;
        }

        Runnable wrappedRunnable = () -> {
            try {
                runnable.run();
            } catch (Exception ex) {
                InternalStaticEmbraceLogger.logError("Failed to run wrapped runnable on Main thread.", ex);
            }
        };

        if (Thread.currentThread() != mainThread) {
            Handler mainHandler = new Handler(mainLooper);
            mainHandler.post(wrappedRunnable);
        } else {
            wrappedRunnable.run();
        }
    }
}
