package io.embrace.android.embracesdk.utils.exceptions.function;

import io.embrace.android.embracesdk.InternalApi;
import io.embrace.android.embracesdk.utils.exceptions.Unchecked;

/**
 * A checked version of {@code Runnable}.
 * <p>
 * This is intended to be used with {@link Unchecked}.
 */
@FunctionalInterface
@InternalApi
public interface CheckedRunnable {

  /**
   * Performs an action.
   *
   * @throws Throwable if an error occurs
   */
  public void run() throws Throwable;

}
