package io.embrace.android.embracesdk.utils.exceptions.function;

import io.embrace.android.embracesdk.InternalApi;
import io.embrace.android.embracesdk.utils.exceptions.Unchecked;

/**
 * A checked version of {@code Supplier}.
 * <p>
 * This is intended to be used with {@link Unchecked}.
 *
 * @param <R> the type of the result
 */
@FunctionalInterface
@InternalApi
public interface CheckedSupplier<R> {

  /**
   * Gets a result.
   *
   * @return a result
   * @throws Throwable if an error occurs
   */
  public R get() throws Throwable;

}
