/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activitytypes.stdout;

import io.engineblock.activityapi.core.Action;
import io.engineblock.activityapi.core.ActionDispenser;
import io.engineblock.activityapi.core.ActivityType;
import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.activitytypes.stdout.AsyncStdoutAction;
import io.engineblock.activitytypes.stdout.StdoutAction;
import io.engineblock.activitytypes.stdout.StdoutActivity;
import io.virtdata.annotations.Service;
import java.util.Optional;

@Service(value=ActivityType.class)
public class StdoutActivityType
implements ActivityType<StdoutActivity> {
    public String getName() {
        return "stdout";
    }

    public StdoutActivity getActivity(ActivityDef activityDef) {
        Optional yaml = activityDef.getParams().getOptionalString(new String[]{"yaml"});
        if (!yaml.isPresent()) {
            throw new RuntimeException("Currently, the stdout activity type requires yaml activity parameter.");
        }
        if (activityDef.getAlias().equals("ALIAS_UNSET")) {
            activityDef.getParams().set("alias", yaml.get());
        }
        return new StdoutActivity(activityDef);
    }

    public ActionDispenser getActionDispenser(StdoutActivity activity) {
        return new StdoutActionDispenser(activity);
    }

    private static class StdoutActionDispenser
    implements ActionDispenser {
        private final StdoutActivity activity;

        private StdoutActionDispenser(StdoutActivity activity) {
            this.activity = activity;
        }

        public Action getAction(int slot) {
            if (this.activity.getActivityDef().getParams().getOptionalString(new String[]{"async"}).isPresent()) {
                return new AsyncStdoutAction(slot, this.activity);
            }
            return new StdoutAction(slot, this.activity);
        }
    }
}

