/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activitytypes.stdout;

import com.codahale.metrics.Timer;
import io.engineblock.activityapi.core.Activity;
import io.engineblock.activityapi.core.BaseAsyncAction;
import io.engineblock.activityapi.core.ops.fluent.opfacets.StartedOp;
import io.engineblock.activityapi.core.ops.fluent.opfacets.TrackedOp;
import io.engineblock.activityapi.planning.OpSequence;
import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.activitytypes.stdout.StdoutActivity;
import io.engineblock.activitytypes.stdout.StdoutOpContext;
import io.virtdata.templates.StringBindings;
import java.util.function.LongFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncStdoutAction
extends BaseAsyncAction<StdoutOpContext, StdoutActivity> {
    private static final Logger logger = LoggerFactory.getLogger(AsyncStdoutAction.class);
    private OpSequence<StringBindings> sequencer;

    public AsyncStdoutAction(int slot, StdoutActivity activity) {
        super((Activity)activity, slot);
    }

    public void onActivityDefUpdate(ActivityDef activityDef) {
        super.onActivityDefUpdate(activityDef);
        this.sequencer = ((StdoutActivity)this.activity).getOpSequence();
    }

    public StdoutOpContext allocateOpData(long cycle) {
        StdoutOpContext opc = new StdoutOpContext();
        try (Timer.Context bindTime = ((StdoutActivity)this.activity).bindTimer.time();){
            opc.stringBindings = (StringBindings)this.sequencer.get(cycle);
            opc.statement = opc.stringBindings.bind(cycle);
            if (((StdoutActivity)this.activity).getShowstmts().booleanValue()) {
                logger.info("STMT(cycle=" + cycle + "):\n" + opc.statement);
            }
        }
        return opc;
    }

    public void startOpCycle(TrackedOp<StdoutOpContext> opc) {
        StartedOp started = opc.start();
        int result = 0;
        try (Timer.Context executeTime = ((StdoutActivity)this.activity).executeTimer.time();){
            ((StdoutActivity)this.activity).write(((StdoutOpContext)opc.getData()).statement);
        }
        catch (Exception e) {
            result = 1;
            started.fail(result);
            throw new RuntimeException("Error writing output:" + e, e);
        }
        finally {
            started.succeed(result);
        }
    }

    public LongFunction<StdoutOpContext> getOpInitFunction() {
        return this::allocateOpData;
    }
}

