/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activitytypes.stdout;

import activityconfig.ParsedStmt;
import activityconfig.StatementsLoader;
import activityconfig.yaml.StmtDef;
import activityconfig.yaml.StmtsDocList;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Timer;
import io.engineblock.activityapi.core.ActivityDefObserver;
import io.engineblock.activityapi.planning.OpSequence;
import io.engineblock.activityapi.planning.SequencePlanner;
import io.engineblock.activityapi.planning.SequencerType;
import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.activityimpl.ParameterMap;
import io.engineblock.activityimpl.SimpleActivity;
import io.engineblock.activitytypes.stdout.TemplateFormat;
import io.engineblock.metrics.ActivityMetrics;
import io.engineblock.metrics.ExceptionMeterMetrics;
import io.engineblock.util.StrInterpolater;
import io.virtdata.core.BindingsTemplate;
import io.virtdata.templates.StringBindings;
import io.virtdata.templates.StringBindingsTemplate;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdoutActivity
extends SimpleActivity
implements ActivityDefObserver {
    private static final Logger logger = LoggerFactory.getLogger(StdoutActivity.class);
    private final Boolean showstmts;
    private final StmtsDocList stmtsDocList;
    public Timer bindTimer;
    public Timer executeTimer;
    public Timer resultTimer;
    public Histogram triesHisto;
    private Writer pw;
    private String fileName;
    private ExceptionMeterMetrics exceptionMeterMetrics;
    private int retry_delay = 0;
    private int retries;
    private OpSequence<StringBindings> opSequence;

    public OpSequence<StringBindings> getOpSequence() {
        return this.opSequence;
    }

    public StdoutActivity(ActivityDef activityDef) {
        super(activityDef);
        StrInterpolater interp = new StrInterpolater(new ActivityDef[]{activityDef});
        String yaml_loc = activityDef.getParams().getOptionalString(new String[]{"yaml"}).orElse("default");
        this.showstmts = activityDef.getParams().getOptionalBoolean("showstatements").orElse(false);
        this.fileName = activityDef.getParams().getOptionalString(new String[]{"filename"}).orElse("stdout");
        this.stmtsDocList = StatementsLoader.load((Logger)logger, (String)yaml_loc, (Function)interp, (String[])new String[]{"activities"});
    }

    public void shutdownActivity() {
        try {
            if (this.pw != null) {
                this.pw.close();
            }
        }
        catch (Exception e) {
            logger.warn("error closing writer:" + e, (Throwable)e);
        }
    }

    public void initActivity() {
        logger.debug("initializing activity: " + this.activityDef.getAlias());
        this.exceptionMeterMetrics = new ExceptionMeterMetrics(this.activityDef);
        this.onActivityDefUpdate(this.activityDef);
        this.opSequence = this.initOpSequencer();
        this.setDefaultsFromOpSequence(this.opSequence);
        this.bindTimer = ActivityMetrics.timer((ActivityDef)this.activityDef, (String)"bind");
        this.executeTimer = ActivityMetrics.timer((ActivityDef)this.activityDef, (String)"execute");
        this.resultTimer = ActivityMetrics.timer((ActivityDef)this.activityDef, (String)"result");
        this.triesHisto = ActivityMetrics.histogram((ActivityDef)this.activityDef, (String)"tries");
        this.pw = this.createPrintWriter();
    }

    protected Writer createPrintWriter() {
        PrintWriter pw;
        if (this.fileName.toLowerCase().equals("stdout")) {
            pw = new PrintWriter(System.out);
        } else {
            try {
                pw = new PrintWriter(this.fileName);
                pw.print("");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException("Error initializing printwriter:" + e, e);
            }
        }
        return pw;
    }

    private OpSequence<StringBindings> initOpSequencer() {
        SequencerType sequencerType = SequencerType.valueOf((String)this.getParams().getOptionalString(new String[]{"seq"}).orElse("bucket"));
        SequencePlanner sequencer = new SequencePlanner(sequencerType);
        String tagfilter = this.activityDef.getParams().getOptionalString(new String[]{"tags"}).orElse("");
        List stmts = this.stmtsDocList.getStmts(tagfilter);
        String format = this.getParams().getOptionalString(new String[]{"format"}).orElse(null);
        if (stmts.size() == 0 && this.stmtsDocList.getDocBindings().size() > 0 || format != null) {
            logger.info("Creating stdout statement template from bindings, since none is otherwise defined.");
            String generatedStmt = this.genStatementTemplate(this.stmtsDocList.getDocBindings().keySet());
            BindingsTemplate bt = new BindingsTemplate();
            this.stmtsDocList.getDocBindings().forEach((arg_0, arg_1) -> ((BindingsTemplate)bt).addFieldBinding(arg_0, arg_1));
            StringBindingsTemplate sbt = new StringBindingsTemplate(generatedStmt, bt);
            StringBindings sb = sbt.resolve();
            sequencer.addOp((Object)sb, 1L);
        } else if (stmts.size() > 0) {
            for (StmtDef stmt : stmts) {
                ParsedStmt parsed = stmt.getParsed().orError();
                BindingsTemplate bt = new BindingsTemplate(parsed.getBindPoints());
                Object statement = parsed.getPositionalStatement(Function.identity());
                Objects.requireNonNull(statement);
                if (!((String)statement).endsWith("\n") && this.getParams().getOptionalBoolean("newline").orElse(true).booleanValue()) {
                    statement = (String)statement + "\n";
                }
                StringBindingsTemplate sbt = new StringBindingsTemplate(stmt.getStmt(), bt);
                StringBindings sb = sbt.resolve();
                sequencer.addOp((Object)sb, Long.valueOf(stmt.getParams().getOrDefault("ratio", "1")).longValue());
            }
        } else {
            logger.error("Unable to create a stdout statement if you have no active statements or bindings configured.");
        }
        OpSequence opSequence = sequencer.resolve();
        return opSequence;
    }

    private String genStatementTemplate(Set<String> keySet) {
        TemplateFormat format = this.getParams().getOptionalString(new String[]{"format"}).map(TemplateFormat::valueOf).orElse(TemplateFormat.assignments);
        boolean ensureNewline = this.getParams().getOptionalBoolean("newline").orElse(true);
        String stmtTemplate = format.format(ensureNewline, new ArrayList<String>(keySet));
        return stmtTemplate;
    }

    public void onActivityDefUpdate(ActivityDef activityDef) {
        super.onActivityDefUpdate(activityDef);
        ParameterMap params = activityDef.getParams();
        this.retry_delay = params.getOptionalInteger("retry_delay").orElse(1000);
        this.retries = params.getOptionalInteger("retries").orElse(3);
    }

    public synchronized void write(String statement) {
        int tries = 0;
        Object e = null;
        while (tries < this.retries) {
            ++tries;
            if (this.pw == null) {
                this.pw = this.createPrintWriter();
            }
            try {
                this.pw.write(statement);
                this.pw.flush();
                return;
            }
            catch (Exception error) {
                logger.warn("Error during write:" + error, (Throwable)error);
                if (this.retry_delay <= 0) continue;
                try {
                    Thread.sleep(this.retry_delay);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        throw new RuntimeException("Retries exhausted: " + tries + "/" + this.retries);
    }

    public Boolean getShowstmts() {
        return this.showstmts;
    }
}

