/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi;

import io.engineblock.activityapi.ParameterMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityDef {
    private static final Logger logger = LoggerFactory.getLogger(ActivityDef.class);
    private static final String FIELD_ALIAS = "alias";
    private static final String FIELD_ATYPE = "type";
    private static final String FIELD_CYCLES = "cycles";
    private static final String FIELD_THREADS = "threads";
    private static final String FIELD_DELAY = "delay";
    private static final String DEFAULT_ALIAS = "unknown-alias";
    private static final String DEFAULT_ATYPE = "unknown-type";
    private static final String DEFAULT_CYCLES = "1";
    private static final int DEFAULT_THREADS = 1;
    private static final int DEFAULT_DELAY = 0;
    private static String[] field_list = new String[]{"alias", "type", "cycles", "threads", "delay"};
    private ParameterMap parameterMap;

    public ActivityDef(String parameterString) {
        this.parameterMap = ParameterMap.parsePositional(parameterString, field_list);
    }

    public ActivityDef(ParameterMap parameterMap) {
        this.parameterMap = parameterMap;
    }

    public static Optional<ActivityDef> parseActivityDefOptionally(String namedActivitySpec) {
        try {
            ActivityDef activityDef = ActivityDef.parseActivityDef(namedActivitySpec);
            return Optional.of(activityDef);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static ActivityDef parseActivityDef(String namedActivitySpec) {
        ParameterMap activityParameterMap = ParameterMap.parsePositional(namedActivitySpec, field_list);
        ActivityDef activityDef = new ActivityDef(activityParameterMap);
        logger.debug("parsed activityDef " + namedActivitySpec + " to-> " + activityDef);
        return activityDef;
    }

    public String toString() {
        return "ActivityDef:" + this.parameterMap.toString();
    }

    public String getAlias() {
        return this.parameterMap.getStringOrDefault(FIELD_ALIAS, DEFAULT_ALIAS);
    }

    public String getActivityType() {
        return this.parameterMap.getStringOrDefault(FIELD_ATYPE, DEFAULT_ATYPE);
    }

    public long getStartCycle() {
        String cycles = this.parameterMap.getStringOrDefault(FIELD_CYCLES, DEFAULT_CYCLES);
        int rangeAt = cycles.indexOf("..");
        if (rangeAt > 0) {
            return Long.valueOf(cycles.substring(0, rangeAt));
        }
        return 0L;
    }

    public void setStartCycle(long startCycle) {
        this.parameterMap.set(FIELD_CYCLES, "" + startCycle + ".." + this.getEndCycle());
    }

    public long getEndCycle() {
        String cycles = this.parameterMap.getStringOrDefault(FIELD_CYCLES, DEFAULT_CYCLES);
        int rangeAt = cycles.indexOf("..");
        if (rangeAt > 0) {
            return Long.valueOf(cycles.substring(rangeAt + 2));
        }
        return Long.valueOf(cycles);
    }

    public void setEndCycle(long endCycle) {
        this.parameterMap.set(FIELD_CYCLES, "" + this.getStartCycle() + ".." + endCycle);
    }

    public int getThreads() {
        return this.parameterMap.getIntOrDefault(FIELD_THREADS, 1);
    }

    public void setThreads(int threads) {
        this.parameterMap.set(FIELD_THREADS, threads);
    }

    public int getInterCycleDelay() {
        return this.parameterMap.getIntOrDefault(FIELD_DELAY, 0);
    }

    public ParameterMap getParams() {
        return this.parameterMap;
    }

    public AtomicLong getChangeCounter() {
        return this.parameterMap.getChangeCounter();
    }

    public void setCycles(String cycles) {
        this.parameterMap.set(FIELD_CYCLES, cycles);
    }

    public void setDelay(int delay) {
        this.parameterMap.set(FIELD_DELAY, delay);
    }

    public String getLogName() {
        return this.toString();
    }
}

