/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.util;

import io.engineblock.util.Tagged;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class TagFilter {
    private Map<String, String> filterby = new HashMap<String, String>();

    public TagFilter(String tagSpec) {
        if (tagSpec != null && !tagSpec.isEmpty()) {
            String[] keyvalues;
            for (String assignment : keyvalues = tagSpec.split("[, ]")) {
                String value;
                String[] keyvalue = assignment.split("[:=]", 2);
                String key = keyvalue[0];
                String string = value = keyvalue.length > 1 ? keyvalue[1] : null;
                if (value != null && value.indexOf("'") == 0 && value.indexOf("'", 1) == value.length() - 1) {
                    value = value.substring(1, value.length() - 1);
                }
                this.filterby.put(key, value);
            }
        }
    }

    protected boolean matches(Map<String, String> itemTags) {
        if (this.filterby.size() == 0) {
            return true;
        }
        if (itemTags.size() == 0) {
            return false;
        }
        for (String filterkey : this.filterby.keySet()) {
            String filterval = this.filterby.get(filterkey);
            Pattern filterPattern = Pattern.compile("^" + filterval + "$");
            String itemval = itemTags.get(filterkey);
            boolean keymatch = itemTags.containsKey(filterkey) && (filterval == null || filterPattern.matcher(itemval).matches());
            if (keymatch) continue;
            return false;
        }
        return true;
    }

    public boolean matches(Tagged item) {
        Map<String, String> itemTags = item.getTags();
        return this.matches(itemTags);
    }

    public Map<String, String> getMap() {
        return this.filterby;
    }
}

