/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.engineblock.activityapi.MetricRegistryService;
import io.engineblock.activityimpl.ActivityDef;
import java.util.ArrayList;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityMetrics {
    private static final Logger logger = LoggerFactory.getLogger(ActivityMetrics.class);
    private static MetricRegistry registry;

    private ActivityMetrics() {
    }

    public static Timer timer(ActivityDef activityDef, String name) {
        Timer timer = ActivityMetrics.get().timer(activityDef.getAlias() + "." + name);
        return timer;
    }

    public static Histogram histogram(ActivityDef activityDef, String name) {
        Histogram histogram = ActivityMetrics.get().histogram(activityDef.getAlias() + "." + name);
        return histogram;
    }

    public static Counter counter(ActivityDef activityDef, String name) {
        Counter counter = ActivityMetrics.get().counter(activityDef.getAlias() + "." + name);
        return counter;
    }

    public static Meter meter(ActivityDef activityDef, String name) {
        Meter meter = ActivityMetrics.get().meter(activityDef.getAlias() + "." + name);
        return meter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MetricRegistry get() {
        if (registry != null) {
            return registry;
        }
        Class<ActivityMetrics> clazz = ActivityMetrics.class;
        synchronized (ActivityMetrics.class) {
            if (registry == null) {
                registry = ActivityMetrics.lookupRegistry();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return registry;
        }
    }

    private static MetricRegistry lookupRegistry() {
        ServiceLoader<MetricRegistryService> metricRegistryServices = ServiceLoader.load(MetricRegistryService.class);
        ArrayList mrss = new ArrayList();
        metricRegistryServices.iterator().forEachRemaining(mrss::add);
        if (mrss.size() == 1) {
            return ((MetricRegistryService)mrss.get(0)).getMetricRegistry();
        }
        String errorMsg = "found " + mrss.size() + " MetricRegistryServices instead of 1";
        logger.error(errorMsg);
        throw new RuntimeException(errorMsg);
    }

    public static MetricRegistry getMetricRegistry() {
        return ActivityMetrics.get();
    }
}

