/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityimpl;

import com.codahale.metrics.Gauge;
import com.google.shaded.common.util.concurrent.RateLimiter;
import io.engineblock.activityapi.ActivityDefObserver;
import io.engineblock.activityapi.Input;
import io.engineblock.activityimpl.ActivityDef;
import java.security.InvalidParameterException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreInput
implements Input,
ActivityDefObserver {
    private static final Logger logger = LoggerFactory.getLogger(CoreInput.class);
    private final AtomicLong cycleValue = new AtomicLong(0L);
    private final AtomicLong min = new AtomicLong(0L);
    private final AtomicLong max = new AtomicLong(Long.MAX_VALUE);
    private RateLimiter rateLimiter;

    public CoreInput(ActivityDef activityDef) {
        this.onActivityDefUpdate(activityDef);
    }

    public CoreInput setNextValue(long newValue) {
        if (newValue < this.min.get() || newValue > this.max.get()) {
            throw new RuntimeException("new value (" + newValue + ") must be within min..max range: [" + this.min + ".." + this.max + "]");
        }
        this.cycleValue.set(newValue);
        return this;
    }

    @Override
    public long getAsLong() {
        if (this.rateLimiter != null) {
            this.rateLimiter.acquire();
        }
        return this.cycleValue.getAndIncrement();
    }

    @Override
    public AtomicLong getMin() {
        return this.min;
    }

    @Override
    public AtomicLong getMax() {
        return this.max;
    }

    @Override
    public void onActivityDefUpdate(ActivityDef activityDef) {
        long endCycle;
        long startCycle = activityDef.getStartCycle();
        if (startCycle > (endCycle = activityDef.getEndCycle())) {
            throw new InvalidParameterException("min (" + this.min + ") must be less than or equal to max (" + this.max + ")");
        }
        if (this.max.get() != endCycle) {
            this.max.set(endCycle);
        }
        if (this.min.get() != startCycle) {
            this.min.set(startCycle);
            this.setNextValue(this.min.get());
        }
        this.updateRateLimiter(activityDef);
    }

    private void updateRateLimiter(ActivityDef activityDef) {
        double rate = activityDef.getParams().getDoubleOrDefault("targetrate", Double.NaN);
        if (!Double.isNaN(rate)) {
            if (this.rateLimiter == null) {
                this.rateLimiter = RateLimiter.create(rate);
            } else {
                this.rateLimiter.setRate(rate);
            }
            Gauge<Double> rateGauge = new Gauge<Double>(){

                @Override
                public Double getValue() {
                    return CoreInput.this.rateLimiter.getRate();
                }
            };
            logger.info("targetrate was set to:" + rate);
        }
    }
}

