/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityimpl;

import com.codahale.metrics.Timer;
import io.engineblock.activityapi.Action;
import io.engineblock.activityapi.ActivityDefObserver;
import io.engineblock.activityapi.ActivityMetrics;
import io.engineblock.activityapi.Input;
import io.engineblock.activityapi.Motor;
import io.engineblock.activityapi.SlotState;
import io.engineblock.activityimpl.ActivityDef;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreMotor
implements ActivityDefObserver,
Motor {
    private static final Logger logger = LoggerFactory.getLogger(CoreMotor.class);
    private final AtomicReference<SlotState> slotState = new AtomicReference<SlotState>(SlotState.Initialized);
    private long slotId;
    private Input input;
    private Action action;
    private Timer timer;
    private ActivityDef activityDef;

    public CoreMotor(ActivityDef activityDef, long slotId, Input input) {
        this.activityDef = activityDef;
        this.slotId = slotId;
        this.setInput(input);
    }

    public CoreMotor(ActivityDef activityDef, long slotId, Input input, Action action) {
        this(activityDef, slotId, input);
        this.setAction(action);
    }

    @Override
    public Motor setInput(Input input) {
        this.input = input;
        return this;
    }

    @Override
    public Input getInput() {
        return this.input;
    }

    @Override
    public Motor setAction(Action action) {
        this.action = action;
        return this;
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public long getSlotId() {
        return this.slotId;
    }

    @Override
    public void run() {
        this.timer = ActivityMetrics.timer(this.activityDef, "cycles");
        if (this.slotState.get() == SlotState.Finished) {
            logger.warn("Input was already exhausted for slot " + this.slotId + ", remaining in finished state.");
        }
        this.enterState(SlotState.Started);
        AtomicLong cycleMax = this.input.getMax();
        this.action.init();
        while (this.slotState.get() == SlotState.Started) {
            Timer.Context cycleTime = this.timer.time();
            long cyclenum = this.input.getAsLong();
            if (cyclenum >= cycleMax.get()) {
                logger.trace("input exhausted (input " + cyclenum + "), stopping motor thread " + this.slotId);
                this.enterState(SlotState.Finished);
                continue;
            }
            logger.trace("cycle " + cyclenum);
            this.action.accept(cyclenum);
            cycleTime.stop();
        }
        if (this.slotState.get() == SlotState.Stopping) {
            this.enterState(SlotState.Stopped);
        }
    }

    public String toString() {
        return "slot:" + this.slotId + "; state:" + (Object)((Object)this.slotState.get());
    }

    @Override
    public void onActivityDefUpdate(ActivityDef activityDef) {
        if (this.input instanceof ActivityDefObserver) {
            ((ActivityDefObserver)((Object)this.input)).onActivityDefUpdate(activityDef);
        }
        if (this.action instanceof ActivityDefObserver) {
            ((ActivityDefObserver)((Object)this.action)).onActivityDefUpdate(activityDef);
        }
    }

    @Override
    public synchronized void requestStop() {
        if (this.slotState.get() == SlotState.Started) {
            this.enterState(SlotState.Stopping);
        } else {
            logger.warn("attempted to stop motor " + this.getSlotId() + ": from non Started state:" + (Object)((Object)this.slotState.get()));
        }
    }

    @Override
    public SlotState getSlotState() {
        return this.slotState.get();
    }

    private synchronized void enterState(SlotState to) {
        SlotState from = this.slotState.get();
        if (!from.canTransitionTo(to)) {
            throw new RuntimeException("Invalid transition from " + (Object)((Object)from) + " to " + (Object)((Object)to));
        }
        this.slotState.compareAndSet(from, to);
    }
}

