/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

public class EngineBlockFiles {
    public static InputStream findRequiredStreamOrFile(String basename, String extension, String ... searchPaths) {
        Optional<InputStream> optionalStreamOrFile = EngineBlockFiles.findOptionalStreamOrFile(basename, extension, searchPaths);
        return optionalStreamOrFile.orElseThrow(() -> new RuntimeException("Unable to find " + basename + " with extension " + extension + " in file system or in classpath, with" + "search paths: " + Arrays.asList(searchPaths).stream().collect(Collectors.joining(","))));
    }

    public static Optional<InputStream> findOptionalStreamOrFile(String basename, String extension, final String ... searchPaths) {
        final String filename = basename.endsWith("." + extension) ? basename : basename + "." + extension;
        ArrayList<String> paths = new ArrayList<String>(){
            {
                this.add(filename);
                this.addAll(Arrays.asList(searchPaths).stream().map(s -> s + File.separator + filename).collect(Collectors.toCollection(ArrayList::new)));
            }
        };
        InputStream stream = null;
        for (String path : paths) {
            try {
                stream = new FileInputStream(path);
            }
            catch (FileNotFoundException fileNotFoundException) {
                ClassLoader classLoader = EngineBlockFiles.class.getClassLoader();
                stream = classLoader.getResourceAsStream(path);
                if (stream == null) continue;
            }
            break;
        }
        return Optional.ofNullable(stream);
    }
}

