/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityimpl.input;

import io.engineblock.activityapi.ActivityDefObserver;
import io.engineblock.activityapi.Input;
import io.engineblock.activityapi.Stoppable;
import io.engineblock.activityimpl.ActivityDef;
import java.util.concurrent.atomic.AtomicLong;

public class LinkedInput
implements Input,
ActivityDefObserver,
Stoppable {
    private AtomicLong cycleValue = new AtomicLong(0L);
    private long linkedPoint = 0L;
    private AtomicLong min = new AtomicLong(0L);
    private AtomicLong max = new AtomicLong(Long.MAX_VALUE);
    private Input linkedInput;
    private ActivityDef activityDef;
    private boolean running = true;

    public LinkedInput(ActivityDef activityDef, Input linkedInput) {
        this.activityDef = activityDef;
        this.linkedInput = linkedInput;
        this.cycleValue.set(linkedInput.getCurrent());
    }

    @Override
    public AtomicLong getMin() {
        return this.min;
    }

    @Override
    public AtomicLong getMax() {
        return this.max;
    }

    @Override
    public long getCurrent() {
        return this.cycleValue.get();
    }

    @Override
    public long getAsLong() {
        long next;
        long current;
        while ((current = this.cycleValue.get()) >= this.linkedPoint || !this.cycleValue.compareAndSet(current, next = current + 1L)) {
            long newLinkedPoint = this.linkedInput.getCurrent();
            if (newLinkedPoint == this.linkedPoint) {
                this.slowMeDown();
                if (this.running) continue;
                return current;
            }
            this.linkedPoint = newLinkedPoint;
        }
        return current;
    }

    protected boolean canAdvance() {
        return this.cycleValue.get() < this.linkedInput.getCurrent();
    }

    private void slowMeDown() {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void onActivityDefUpdate(ActivityDef activityDef) {
    }

    @Override
    public void requestStop() {
        this.running = false;
    }
}

