/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi;

import io.engineblock.activityapi.ActionDispenser;
import io.engineblock.activityapi.ActivitiesAware;
import io.engineblock.activityapi.Activity;
import io.engineblock.activityapi.InputDispenser;
import io.engineblock.activityapi.MotorDispenser;
import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.activityimpl.SimpleActivity;
import io.engineblock.activityimpl.action.CoreActionDispenser;
import io.engineblock.activityimpl.input.CoreInputDispenser;
import io.engineblock.activityimpl.motor.CoreMotorDispenser;
import java.util.Map;

public interface ActivityType {
    public String getName();

    default public Activity getActivity(ActivityDef activityDef) {
        SimpleActivity activity = new SimpleActivity(activityDef);
        return activity;
    }

    default public Activity getAssembledActivity(ActivityDef activityDef, Map<String, Activity> activities) {
        Activity activity = this.getActivity(activityDef);
        InputDispenser inputDispenser = this.getInputDispenser(activity);
        if (inputDispenser instanceof ActivitiesAware) {
            ((ActivitiesAware)((Object)inputDispenser)).setActivitiesMap(activities);
        }
        activity.setInputDispenser(inputDispenser);
        ActionDispenser actionDispenser = this.getActionDispenser(activity);
        if (actionDispenser instanceof ActivitiesAware) {
            ((ActivitiesAware)((Object)actionDispenser)).setActivitiesMap(activities);
        }
        activity.setActionDispenser(actionDispenser);
        MotorDispenser motorDispenser = this.getMotorDispenser(activity, inputDispenser, actionDispenser);
        if (motorDispenser instanceof ActivitiesAware) {
            ((ActivitiesAware)((Object)motorDispenser)).setActivitiesMap(activities);
        }
        activity.setMotorDispenser(motorDispenser);
        return activity;
    }

    default public ActionDispenser getActionDispenser(Activity activity) {
        return new CoreActionDispenser(activity);
    }

    default public InputDispenser getInputDispenser(Activity activity) {
        return new CoreInputDispenser(activity);
    }

    default public MotorDispenser getMotorDispenser(Activity activity, InputDispenser inputDispenser, ActionDispenser actionDispenser) {
        return new CoreMotorDispenser(activity, inputDispenser, actionDispenser);
    }
}

