/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityimpl;

import io.engineblock.activityimpl.motor.ParamsParser;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.script.Bindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterMap
extends ConcurrentHashMap<String, Object>
implements Bindings {
    private static final Logger logger = LoggerFactory.getLogger(ParameterMap.class);
    private final AtomicLong changeCounter = new AtomicLong(0L);
    private final LinkedList<Listener> listeners = new LinkedList();
    private static Pattern encodedParamsSquote = Pattern.compile("(?<param>\\w+?)='(?<value>[^']+?);");
    private static Pattern encodedParamsDquote = Pattern.compile("(?<param>\\w+?)=\"(?<value>[^\"]+?);");
    private static Pattern encodedParamsPattern = Pattern.compile("(?<param>\\w+?)=(?<value>.+?);");

    public ParameterMap(Map<String, String> valueMap) {
        logger.trace("new parameter map:" + valueMap.toString());
        super.putAll(valueMap);
    }

    public long getLongOrDefault(String paramName, long defaultLongValue) {
        Optional<String> l = Optional.ofNullable(super.get(paramName)).map(String::valueOf);
        return l.map(Long::valueOf).orElse(defaultLongValue);
    }

    public double getDoubleOrDefault(String paramName, double defaultDoubleValue) {
        Optional<String> d = Optional.ofNullable(super.get(paramName)).map(String::valueOf);
        return d.map(Double::valueOf).orElse(defaultDoubleValue);
    }

    public String getStringOrDefault(String paramName, String defaultStringValue) {
        Optional<String> s = Optional.ofNullable(super.get(paramName)).map(String::valueOf);
        return s.orElse(defaultStringValue);
    }

    public Optional<String> getOptionalString(String paramName) {
        return Optional.ofNullable(super.get(paramName)).map(String::valueOf);
    }

    public Optional<Long> getOptionalLong(String paramName) {
        return Optional.ofNullable(super.get(paramName)).map(String::valueOf).map(Long::valueOf);
    }

    public Optional<Double> getOptionalDouble(String paramName) {
        return Optional.ofNullable(super.get(paramName)).map(String::valueOf).map(Double::valueOf);
    }

    public Optional<Boolean> getOptionalBoolean(String paramName) {
        return Optional.ofNullable(super.get(paramName)).map(String::valueOf).map(Boolean::valueOf);
    }

    public int getIntOrDefault(String paramName, int defaultIntValue) {
        Optional<String> i = Optional.ofNullable(super.get(paramName)).map(String::valueOf);
        return i.map(Integer::valueOf).orElse(defaultIntValue);
    }

    public boolean getBoolOrDefault(String paramName, boolean defaultBoolValue) {
        Optional<String> b = Optional.ofNullable(super.get(paramName)).map(String::valueOf);
        return b.map(Boolean::valueOf).orElse(defaultBoolValue);
    }

    public Long takeLongOrDefault(String paramName, Long defaultLongValue) {
        Optional<String> l = Optional.ofNullable(super.remove(paramName)).map(String::valueOf);
        Long lval = l.map(Long::valueOf).orElse(defaultLongValue);
        this.markMutation();
        return lval;
    }

    public Double takeDoubleOrDefault(String paramName, double defaultDoubleValue) {
        Optional<String> d = Optional.ofNullable(super.remove(paramName)).map(String::valueOf);
        Double dval = d.map(Double::valueOf).orElse(defaultDoubleValue);
        this.markMutation();
        return dval;
    }

    public String takeStringOrDefault(String paramName, String defaultStringValue) {
        Optional<String> s = Optional.ofNullable(super.remove(paramName)).map(String::valueOf);
        String sval = s.orElse(defaultStringValue);
        this.markMutation();
        return sval;
    }

    public int takeIntOrDefault(String paramName, int paramDefault) {
        Optional<String> i = Optional.ofNullable(super.remove(paramName)).map(String::valueOf);
        int ival = i.map(Integer::valueOf).orElse(paramDefault);
        this.markMutation();
        return ival;
    }

    public boolean takeBoolOrDefault(String paramName, boolean defaultBoolValue) {
        Optional<String> b = Optional.ofNullable(super.remove(paramName)).map(String::valueOf);
        boolean bval = b.map(Boolean::valueOf).orElse(defaultBoolValue);
        this.markMutation();
        return bval;
    }

    @Override
    public Object get(Object key) {
        logger.info("getting parameter " + key);
        return super.get(key);
    }

    public void set(String paramName, Object newValue) {
        super.put(paramName, String.valueOf(newValue));
        logger.info("parameter " + paramName + " set to " + newValue);
        this.markMutation();
    }

    @Override
    public Object put(String name, Object value) {
        String oldVal = super.put(name, String.valueOf(value));
        logger.info("parameter " + name + " put to " + value);
        this.markMutation();
        return oldVal;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> toMerge) {
        for (Map.Entry<? extends String, ? extends Object> entry : toMerge.entrySet()) {
            super.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        this.markMutation();
    }

    @Override
    public Object remove(Object key) {
        Object removed = super.remove(key);
        logger.info("parameter " + key + " removed");
        this.markMutation();
        return removed;
    }

    @Override
    public void clear() {
        logger.info("parameter map cleared:" + this.toString());
        super.clear();
        this.markMutation();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        logger.info("getting entry set for " + this.toString());
        return super.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, Object>((String)e.getKey(), e.getValue()){}).collect(Collectors.toCollection(HashSet::new));
    }

    private void markMutation() {
        this.changeCounter.incrementAndGet();
        logger.debug("calling " + this.listeners.size() + " listeners.");
        this.callListeners();
    }

    public AtomicLong getChangeCounter() {
        return this.changeCounter;
    }

    @Override
    public String toString() {
        return "(" + this.changeCounter.get() + ")/" + super.toString();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void callListeners() {
        for (Listener listener : this.listeners) {
            logger.info("calling listener:" + listener);
            listener.handleParameterMapUpdate(this);
        }
    }

    public int getSize() {
        return super.size();
    }

    public static ParameterMap parseOrException(String encodedParams) {
        if (encodedParams == null) {
            throw new RuntimeException("Must provide a non-null String to parse parameters.");
        }
        Map<String, String> parsedMap = ParamsParser.parse(encodedParams);
        return new ParameterMap(parsedMap);
    }

    public static Optional<ParameterMap> parseParams(String encodedParams) {
        try {
            return Optional.ofNullable(ParameterMap.parseOrException(encodedParams));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public Map<String, String> getStringStringMap() {
        return new HashMap<String, String>(){
            {
                for (Map.Entry<String, Object> entry : ParameterMap.this.entrySet()) {
                    this.put(entry.getKey().toString(), entry.getValue().toString());
                }
            }
        };
    }

    public static interface Listener {
        public void handleParameterMapUpdate(ParameterMap var1);
    }
}

