/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityimpl.motor;

import com.codahale.metrics.Timer;
import io.engineblock.activityapi.Action;
import io.engineblock.activityapi.ActivityDefObserver;
import io.engineblock.activityapi.Input;
import io.engineblock.activityapi.Motor;
import io.engineblock.activityapi.RunState;
import io.engineblock.activityapi.Stoppable;
import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.activityimpl.SlotStateTracker;
import io.engineblock.metrics.ActivityMetrics;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreMotor
implements ActivityDefObserver,
Motor,
Stoppable {
    private static final Logger logger = LoggerFactory.getLogger(CoreMotor.class);
    private long slotId;
    private Input input;
    private Action action;
    private Timer timer;
    private ActivityDef activityDef;
    private SlotStateTracker slotStateTracker;
    private AtomicReference<RunState> slotState;

    public CoreMotor(ActivityDef activityDef, long slotId, Input input) {
        this.activityDef = activityDef;
        this.slotId = slotId;
        this.setInput(input);
        this.slotStateTracker = new SlotStateTracker(slotId);
        this.slotState = this.slotStateTracker.getAtomicSlotState();
    }

    public CoreMotor(ActivityDef activityDef, long slotId, Input input, Action action) {
        this(activityDef, slotId, input);
        this.setAction(action);
    }

    @Override
    public Motor setInput(Input input) {
        this.input = input;
        return this;
    }

    @Override
    public Input getInput() {
        return this.input;
    }

    @Override
    public Motor setAction(Action action) {
        this.action = action;
        return this;
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public long getSlotId() {
        return this.slotId;
    }

    @Override
    public SlotStateTracker getSlotStateTracker() {
        return this.slotStateTracker;
    }

    @Override
    public void run() {
        this.timer = ActivityMetrics.timer(this.activityDef, "cycles");
        if (this.slotState.get() == RunState.Finished) {
            logger.warn("Input was already exhausted for slot " + this.slotId + ", remaining in finished state.");
        }
        this.slotStateTracker.enterState(RunState.Running);
        AtomicLong cycleMax = this.input.getMax();
        this.action.init();
        while (this.slotState.get() == RunState.Running) {
            Timer.Context cycleTime = this.timer.time();
            Throwable throwable = null;
            try {
                long cyclenum = this.input.getAsLong();
                if (cyclenum >= cycleMax.get()) {
                    logger.trace("input exhausted (input " + cyclenum + "), stopping motor thread " + this.slotId);
                    this.slotStateTracker.enterState(RunState.Finished);
                    continue;
                }
                if (this.slotState.get() != RunState.Running) {
                    logger.trace("motor stopped after input (input " + cyclenum + "), stopping motor thread " + this.slotId);
                    continue;
                }
                logger.trace("cycle " + cyclenum);
                this.action.accept(cyclenum);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (cycleTime == null) continue;
                if (throwable != null) {
                    try {
                        cycleTime.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                cycleTime.close();
            }
        }
        if (this.slotState.get() == RunState.Stopping) {
            this.slotStateTracker.enterState(RunState.Stopped);
        }
    }

    public String toString() {
        return "slot:" + this.slotId + "; state:" + (Object)((Object)this.slotState.get());
    }

    @Override
    public void onActivityDefUpdate(ActivityDef activityDef) {
        if (this.input instanceof ActivityDefObserver) {
            ((ActivityDefObserver)((Object)this.input)).onActivityDefUpdate(activityDef);
        }
        if (this.action instanceof ActivityDefObserver) {
            ((ActivityDefObserver)((Object)this.action)).onActivityDefUpdate(activityDef);
        }
    }

    @Override
    public synchronized void requestStop() {
        if (this.slotState.get() == RunState.Running) {
            if (this.input instanceof Stoppable) {
                ((Stoppable)((Object)this.input)).requestStop();
            }
            if (this.action instanceof Stoppable) {
                ((Stoppable)((Object)this.action)).requestStop();
            }
            this.slotStateTracker.enterState(RunState.Stopping);
        } else {
            logger.warn("attempted to stop motor " + this.getSlotId() + ": from non Running state:" + (Object)((Object)this.slotState.get()));
        }
    }
}

