/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.Timer;
import java.util.HashMap;
import java.util.Map;

public abstract class CapabilityHook<T>
implements MetricRegistryListener {
    private Map<String, T> capables = new HashMap<String, T>();

    public abstract void onCapableAdded(String var1, T var2);

    public abstract void onCapableRemoved(String var1, T var2);

    protected abstract Class<T> getCapabilityClass();

    @Override
    public void onHistogramAdded(String name, Histogram metric) {
        Class<T> capClass = this.getCapabilityClass();
        if (capClass.isAssignableFrom(metric.getClass())) {
            T capable = capClass.cast(metric);
            this.capables.put(name, capable);
            this.onCapableAdded(name, capable);
        }
    }

    @Override
    public void onHistogramRemoved(String name) {
        T removed = this.capables.remove(name);
        if (removed != null) {
            this.onCapableRemoved(name, removed);
        }
    }

    @Override
    public void onTimerAdded(String name, Timer metric) {
        Class<T> capClass = this.getCapabilityClass();
        if (capClass.isAssignableFrom(metric.getClass())) {
            T capable = capClass.cast(metric);
            this.capables.put(name, capable);
            this.onCapableAdded(name, capable);
        }
    }

    @Override
    public void onTimerRemoved(String name) {
        T removed = this.capables.remove(name);
        if (removed != null) {
            this.onCapableRemoved(name, removed);
        }
    }

    @Override
    public void onGaugeAdded(String name, Gauge<?> metric) {
        Class<T> capClass = this.getCapabilityClass();
        if (capClass.isAssignableFrom(metric.getClass())) {
            T capable = capClass.cast(metric);
            this.capables.put(name, capable);
            this.onCapableAdded(name, capable);
        }
    }

    @Override
    public void onGaugeRemoved(String name) {
        T removed = this.capables.remove(name);
        if (removed != null) {
            this.onCapableRemoved(name, removed);
        }
    }

    @Override
    public void onCounterAdded(String name, Counter metric) {
        Class<T> capClass = this.getCapabilityClass();
        if (capClass.isAssignableFrom(metric.getClass())) {
            T capable = capClass.cast(metric);
            this.capables.put(name, capable);
            this.onCapableAdded(name, capable);
        }
    }

    @Override
    public void onCounterRemoved(String name) {
        T removed = this.capables.remove(name);
        if (removed != null) {
            this.onCapableRemoved(name, removed);
        }
    }

    @Override
    public void onMeterAdded(String name, Meter metric) {
        Class<T> capClass = this.getCapabilityClass();
        if (capClass.isAssignableFrom(metric.getClass())) {
            T capable = capClass.cast(metric);
            this.capables.put(name, capable);
            this.onCapableAdded(name, capable);
        }
    }

    @Override
    public void onMeterRemoved(String name) {
        T removed = this.capables.remove(name);
        if (removed != null) {
            this.onCapableRemoved(name, removed);
        }
    }
}

