/*
 * Decompiled with CFR 0.152.
 */
package activityconfig;

import activityconfig.MultiMapLookup;
import activityconfig.yaml.AssembledStmtsBlock;
import activityconfig.yaml.StmtsBlock;
import activityconfig.yaml.StmtsDoc;
import io.engineblock.util.Tagged;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AssembledStmtsDoc
implements Tagged {
    private StmtsDoc rawStmtsDoc;

    public AssembledStmtsDoc(StmtsDoc rawStmtsDoc) {
        this.rawStmtsDoc = rawStmtsDoc;
    }

    public List<AssembledStmtsBlock> getAssembledBlocks() {
        ArrayList<AssembledStmtsBlock> assembledBlocks = new ArrayList<AssembledStmtsBlock>();
        int blockIdx = 0;
        for (StmtsBlock rawStmtsBlock : this.rawStmtsDoc.getBlocks()) {
            AssembledStmtsBlock compositeBlock = new AssembledStmtsBlock(rawStmtsBlock, this.rawStmtsDoc, ++blockIdx);
            String compositeName = this.rawStmtsDoc.getName() + (rawStmtsBlock.getName().isEmpty() ? "" : "-" + rawStmtsBlock.getName());
            compositeBlock.setName(compositeName);
            compositeBlock.setTags(new MultiMapLookup().add(rawStmtsBlock.getTags()).add(this.rawStmtsDoc.getTags()));
            compositeBlock.setParams(new MultiMapLookup().add(rawStmtsBlock.getParams()).add(this.rawStmtsDoc.getParams()));
            compositeBlock.setBindings(new MultiMapLookup().add(rawStmtsBlock.getBindings()).add(this.rawStmtsDoc.getBindings()));
            assembledBlocks.add(compositeBlock);
        }
        return assembledBlocks;
    }

    @Override
    public Map<String, String> getTags() {
        return this.rawStmtsDoc.getTags();
    }

    public String getName() {
        return this.rawStmtsDoc.getName();
    }
}

