/*
 * Decompiled with CFR 0.152.
 */
package activityconfig.yaml;

import activityconfig.yaml.BlockParams;
import activityconfig.yaml.StatementDef;
import activityconfig.yaml.StmtsBlock;
import activityconfig.yaml.StmtsDoc;
import java.util.ArrayList;
import java.util.List;

public class AssembledStmtsBlock
extends BlockParams {
    private final StmtsBlock rawStmtsBlock;
    private StmtsDoc rawStmtsDoc;
    private int blockIdx;

    public AssembledStmtsBlock(StmtsBlock rawStmtsBlock, StmtsDoc rawStmtsDoc, int blockIdx) {
        this.rawStmtsBlock = rawStmtsBlock;
        this.rawStmtsDoc = rawStmtsDoc;
        this.blockIdx = blockIdx;
    }

    public List<StatementDef> getAssembledStatements() {
        ArrayList<StatementDef> statementDefs = new ArrayList<StatementDef>();
        List<String> statements = this.rawStmtsBlock.getStatements();
        for (int stmt = 0; stmt < statements.size(); ++stmt) {
            String stmtName = this.getName() + "--" + (stmt + 1);
            StatementDef statementDef = new StatementDef(stmtName, statements.get(stmt));
            statementDefs.add(statementDef);
        }
        return statementDefs;
    }

    @Override
    public String getName() {
        StringBuilder sb = new StringBuilder();
        if (!this.rawStmtsDoc.getName().isEmpty()) {
            sb.append(this.rawStmtsDoc.getName()).append("--");
        }
        if (!this.rawStmtsBlock.getName().isEmpty()) {
            sb.append(this.rawStmtsBlock.getName());
        } else {
            sb.append("block").append(this.blockIdx);
        }
        return sb.toString();
    }
}

