/*
 * Decompiled with CFR 0.152.
 */
package activityconfig.yaml;

import activityconfig.yaml.StmtsBlock;
import activityconfig.yaml.StmtsDoc;
import activityconfig.yaml.StmtsDocList;
import io.engineblock.activityimpl.ActivityInitializationError;
import io.engineblock.util.EngineBlockFiles;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.Constructor;

public class YamlStatementLoader {
    private static final Logger logger = LoggerFactory.getLogger(YamlStatementLoader.class);
    List<Function<String, String>> imageTransformers = new ArrayList<Function<String, String>>();
    List<Function<String, String>> stringTransformers = new ArrayList<Function<String, String>>();

    public StmtsDocList load(String fromPath, String ... searchPaths) {
        InputStream stream = EngineBlockFiles.findRequiredStreamOrFile(fromPath, "yaml", searchPaths);
        String data = "";
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(stream));){
            data = buffer.lines().collect(Collectors.joining("\n"));
        }
        catch (Exception e) {
            throw new RuntimeException("Error while reading yaml stream data:" + e);
        }
        for (Function<String, String> xform : this.stringTransformers) {
            try {
                logger.debug("Applying string transformer to yaml data:" + xform);
                data = xform.apply(data);
            }
            catch (Exception e) {
                ActivityInitializationError t = new ActivityInitializationError("Error applying string transform to input", e);
                logger.error(t.getMessage(), t);
                throw t;
            }
        }
        Yaml yaml = this.getCustomYaml();
        try {
            Iterable<Object> objects = yaml.loadAll(data);
            ArrayList<StmtsDoc> stmtListList = new ArrayList<StmtsDoc>();
            for (Object object : objects) {
                StmtsDoc tgsd = (StmtsDoc)object;
                stmtListList.add(tgsd);
            }
            return new StmtsDocList(stmtListList);
        }
        catch (Exception e) {
            logger.error("Error loading yaml from " + fromPath, e);
            throw e;
        }
    }

    private Yaml getCustomYaml() {
        Constructor constructor = new Constructor(StmtsDoc.class);
        TypeDescription tds = new TypeDescription(StmtsDoc.class);
        tds.putListPropertyType("blocks", StmtsBlock.class);
        constructor.addTypeDescription(tds);
        return new Yaml(constructor);
    }
}

