/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityimpl.motor;

import com.codahale.metrics.Timer;
import com.google.shaded.common.util.concurrent.RateLimiter;
import io.engineblock.activityapi.Action;
import io.engineblock.activityapi.ActivityDefObserver;
import io.engineblock.activityapi.Input;
import io.engineblock.activityapi.Motor;
import io.engineblock.activityapi.MultiPhaseAction;
import io.engineblock.activityapi.RateLimiterProvider;
import io.engineblock.activityapi.RunState;
import io.engineblock.activityapi.Stoppable;
import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.activityimpl.SlotStateTracker;
import io.engineblock.metrics.ActivityMetrics;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreMotor
implements ActivityDefObserver,
Motor,
Stoppable {
    private static final Logger logger = LoggerFactory.getLogger(CoreMotor.class);
    private long slotId;
    private Input input;
    private Action action;
    private ActivityDef activityDef;
    private SlotStateTracker slotStateTracker;
    private AtomicReference<RunState> slotState;
    private RateLimiter rateLimiter;
    private long stride = 1L;

    public CoreMotor(ActivityDef activityDef, long slotId, Input input) {
        this.activityDef = activityDef;
        this.slotId = slotId;
        this.setInput(input);
        this.slotStateTracker = new SlotStateTracker(slotId);
        this.slotState = this.slotStateTracker.getAtomicSlotState();
        this.onActivityDefUpdate(activityDef);
    }

    public CoreMotor(ActivityDef activityDef, long slotId, Input input, Action action) {
        this(activityDef, slotId, input);
        this.setAction(action);
    }

    @Override
    public Motor setInput(Input input) {
        this.input = input;
        return this;
    }

    @Override
    public Input getInput() {
        return this.input;
    }

    @Override
    public Motor setAction(Action action) {
        this.action = action;
        return this;
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public long getSlotId() {
        return this.slotId;
    }

    @Override
    public SlotStateTracker getSlotStateTracker() {
        return this.slotStateTracker;
    }

    @Override
    public void run() {
        Timer cyclesTimer = ActivityMetrics.timer(this.activityDef, "cycles");
        Timer phasesTimer = ActivityMetrics.timer(this.activityDef, "phases");
        Timer stridesTimer = ActivityMetrics.timer(this.activityDef, "strides");
        if (this.slotState.get() == RunState.Finished) {
            logger.warn("Input was already exhausted for slot " + this.slotId + ", remaining in finished state.");
        }
        this.slotStateTracker.enterState(RunState.Running);
        MultiPhaseAction multiPhaseAction = null;
        if (this.action instanceof MultiPhaseAction) {
            multiPhaseAction = (MultiPhaseAction)this.action;
        }
        AtomicLong cycleMax = this.input.getMax();
        this.action.init();
        while (this.slotState.get() == RunState.Running) {
            long thisIntervalStart = this.input.getInterval(this.stride);
            long nextIntervalStart = thisIntervalStart + this.stride;
            if (thisIntervalStart >= cycleMax.get()) {
                logger.trace("input exhausted (input " + thisIntervalStart + "), stopping motor thread " + this.slotId);
                this.slotStateTracker.enterState(RunState.Finished);
                continue;
            }
            Timer.Context stridesTime = stridesTimer.time();
            Throwable throwable = null;
            try {
                for (long cyclenum = thisIntervalStart; cyclenum < nextIntervalStart; ++cyclenum) {
                    if (this.slotState.get() != RunState.Running) {
                        logger.trace("motor stopped after input (input " + cyclenum + "), stopping motor thread " + this.slotId);
                        continue;
                    }
                    try (Timer.Context cycleTime = cyclesTimer.time();){
                        logger.trace("cycle " + cyclenum);
                        try (Timer.Context phaseTime = phasesTimer.time();){
                            this.action.accept(cyclenum);
                        }
                        if (multiPhaseAction == null) continue;
                        while (multiPhaseAction.incomplete()) {
                            if (this.rateLimiter != null) {
                                this.rateLimiter.acquire();
                            }
                            phaseTime = phasesTimer.time();
                            var17_18 = null;
                            try {
                                this.action.accept(cyclenum);
                            }
                            catch (Throwable throwable2) {
                                var17_18 = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (phaseTime == null) continue;
                                if (var17_18 != null) {
                                    try {
                                        phaseTime.close();
                                    }
                                    catch (Throwable throwable3) {
                                        var17_18.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                phaseTime.close();
                            }
                        }
                        continue;
                    }
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stridesTime == null) continue;
                if (throwable != null) {
                    try {
                        stridesTime.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                stridesTime.close();
            }
        }
        if (this.slotState.get() == RunState.Stopping) {
            this.slotStateTracker.enterState(RunState.Stopped);
        }
    }

    public String toString() {
        return "slot:" + this.slotId + "; state:" + (Object)((Object)this.slotState.get());
    }

    @Override
    public void onActivityDefUpdate(ActivityDef activityDef) {
        if (this.input instanceof ActivityDefObserver) {
            ((ActivityDefObserver)((Object)this.input)).onActivityDefUpdate(activityDef);
        }
        if (this.action instanceof ActivityDefObserver) {
            ((ActivityDefObserver)((Object)this.action)).onActivityDefUpdate(activityDef);
        }
        this.rateLimiter = this.input instanceof RateLimiterProvider ? ((RateLimiterProvider)((Object)this.input)).getRateLimiter() : null;
        this.stride = activityDef.getParams().getOptionalLong("stride").orElse(1L);
    }

    @Override
    public synchronized void requestStop() {
        if (this.slotState.get() == RunState.Running) {
            if (this.input instanceof Stoppable) {
                ((Stoppable)((Object)this.input)).requestStop();
            }
            if (this.action instanceof Stoppable) {
                ((Stoppable)((Object)this.action)).requestStop();
            }
            this.slotStateTracker.enterState(RunState.Stopping);
        } else {
            logger.warn("attempted to stop motor " + this.getSlotId() + ": from non Running state:" + (Object)((Object)this.slotState.get()));
        }
    }
}

