/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.cycletracking.buffers.cycles;

import io.engineblock.activityapi.cycletracking.buffers.cycles.CycleArray;
import io.engineblock.activityapi.cycletracking.buffers.cycles.CycleSegment;
import java.util.Arrays;

public class CycleSegmentBuffer {
    long[] cycleNumbers;
    int pos = 0;

    public CycleSegmentBuffer(int size) {
        this.cycleNumbers = new long[size];
    }

    public void append(long cycleNumber) {
        this.cycleNumbers[this.pos++] = cycleNumber;
    }

    public CycleSegment toReadable() {
        if (this.pos == this.cycleNumbers.length) {
            return new CycleArray.ArraySegment(this.cycleNumbers);
        }
        return new CycleArray.ArraySegment(Arrays.copyOfRange(this.cycleNumbers, 0, this.pos));
    }

    public int remaining() {
        return this.cycleNumbers.length - this.pos;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CycleSegmentBuffer (size=").append(this.cycleNumbers.length).append(")=>");
        if (this.cycleNumbers.length > 100) {
            sb.append(Arrays.toString(Arrays.copyOfRange(this.cycleNumbers, 0, 20))).append(", ..., ").append(Arrays.toString(Arrays.copyOfRange(this.cycleNumbers, this.cycleNumbers.length - 21, this.cycleNumbers.length - 1)));
        } else {
            sb.append(Arrays.toString(this.cycleNumbers));
        }
        return sb.toString();
    }
}

