/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.cycletracking.buffers.results;

import io.engineblock.activityapi.cycletracking.buffers.results.CycleResult;
import io.engineblock.activityapi.cycletracking.buffers.results.CycleResultsSegment;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class CycleResultsSegmentReadable
implements CycleResultsSegment {
    private static final int BYTES = 9;
    private final ByteBuffer buf;

    public CycleResultsSegmentReadable(ByteBuffer buf) {
        this.buf = buf;
    }

    public static CycleResultsSegment forCycleResult(long completedCycle, int result) {
        ByteBuffer single = ByteBuffer.allocate(9);
        single.putLong(completedCycle).put((byte)result);
        single.flip();
        return new CycleResultsSegmentReadable(single);
    }

    @Override
    @NotNull
    public Iterator<CycleResult> iterator() {
        return new Iter();
    }

    public String toString() {
        ByteBuffer bb = ByteBuffer.wrap(this.buf.array());
        StringBuilder sb = new StringBuilder();
        while (bb.remaining() > 0) {
            long cycle = bb.getLong();
            byte value = bb.get();
            sb.append(cycle).append("=>").append(value).append("\n");
        }
        return sb.toString();
    }

    @Override
    public long getCount() {
        return this.buf.limit() / 9;
    }

    @Override
    public long getMinCycle() {
        if (this.buf != null && this.buf.limit() > 0) {
            return this.buf.getLong(0);
        }
        return Long.MIN_VALUE;
    }

    private class BBCycleResult
    implements CycleResult {
        private int offset;

        BBCycleResult(int offset) {
            this.offset = offset;
        }

        @Override
        public long getCycle() {
            return CycleResultsSegmentReadable.this.buf.getLong(this.offset);
        }

        @Override
        public int getResult() {
            return CycleResultsSegmentReadable.this.buf.get(this.offset + 8);
        }
    }

    private class Iter
    implements Iterator<CycleResult> {
        private int offset = 0;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            return this.offset + 9 <= CycleResultsSegmentReadable.this.buf.limit();
        }

        @Override
        public CycleResult next() {
            BBCycleResult cycleResult = new BBCycleResult(this.offset);
            this.offset += 9;
            return cycleResult;
        }
    }
}

