/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.cycletracking.buffers.results_rle;

import io.engineblock.activityapi.cycletracking.buffers.CycleResultSegmentsReadable;
import io.engineblock.activityapi.cycletracking.buffers.results.CycleResultsSegment;
import io.engineblock.activityapi.cycletracking.buffers.results_rle.CycleSpanResults;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class CycleResultsRLEBufferReadable
implements CycleResultSegmentsReadable {
    public static final int BYTES = 17;
    private final ByteBuffer buf;

    public CycleResultsRLEBufferReadable(ByteBuffer buf) {
        this.buf = buf;
    }

    public CycleResultsRLEBufferReadable(int readSizeInSpans, ByteBuffer src) {
        int bufsize = Math.min(readSizeInSpans *= 17, src.remaining());
        byte[] bbuf = new byte[bufsize];
        src.get(bbuf);
        this.buf = ByteBuffer.wrap(bbuf);
    }

    @Override
    @NotNull
    public Iterator<CycleResultsSegment> iterator() {
        return new ResultSpanIterator(this.buf);
    }

    private class ResultSpanIterator
    implements Iterator<CycleResultsSegment> {
        private final ByteBuffer iterbuf;

        public ResultSpanIterator(ByteBuffer buf) {
            this.iterbuf = buf;
        }

        @Override
        public boolean hasNext() {
            return this.iterbuf.remaining() > 0;
        }

        @Override
        public CycleResultsSegment next() {
            long min = this.iterbuf.getLong();
            long nextMin = this.iterbuf.getLong();
            byte result = this.iterbuf.get();
            return new CycleSpanResults(min, nextMin, result);
        }

        public String toString() {
            return "ResultSpanIterator (" + this.iterbuf.toString() + ")";
        }
    }
}

