/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.cycletracking.buffers.results_rle;

import io.engineblock.activityapi.cycletracking.buffers.results.CycleResult;
import io.engineblock.activityapi.cycletracking.buffers.results_rle.CycleResultsRLEBufferReadable;
import io.engineblock.activityapi.output.Output;
import java.nio.ByteBuffer;

public class CycleResultsRLEBufferTarget
implements Output {
    public static final int BYTES = 17;
    private ByteBuffer buf;
    private long lastCycle = Long.MIN_VALUE;
    private long lastResult = Integer.MIN_VALUE;
    private long runlength = 0L;
    private boolean flushed = false;

    public CycleResultsRLEBufferTarget(ByteBuffer buf) {
        this.buf = buf;
    }

    public CycleResultsRLEBufferTarget(int elementCount) {
        this(ByteBuffer.allocate(elementCount * 17));
    }

    public CycleResultsRLEBufferReadable toReadable() {
        this.flush();
        ByteBuffer readable = this.buf.duplicate();
        readable.flip();
        return new CycleResultsRLEBufferReadable(readable);
    }

    public ByteBuffer toByteBuffer() {
        this.flush();
        ByteBuffer bb = this.buf.duplicate();
        bb.flip();
        return bb;
    }

    @Override
    public boolean onCycleResult(long cycle, int result) {
        if (this.buf == null) {
            throw new RuntimeException("Attempt to append a buffer that is active for reading with cycle:" + cycle + " result:" + result);
        }
        if (this.buf.remaining() < 17) {
            return false;
        }
        if ((cycle != this.lastCycle + 1L || this.lastResult != (long)result) && this.lastCycle != Long.MIN_VALUE) {
            this.checkpoint(this.lastCycle + 1L - this.runlength, this.lastCycle + 1L, this.lastResult);
        }
        this.lastCycle = cycle;
        this.lastResult = result;
        ++this.runlength;
        this.flushed = false;
        return true;
    }

    private void checkpoint(long istart, long iend, long lastResult) {
        if (lastResult > 127L) {
            throw new RuntimeException("Unable to encode values greater than Byte.MAX_VALUE.");
        }
        this.buf.putLong(istart).putLong(iend).put((byte)lastResult);
        this.runlength = 0L;
    }

    public int getBufferCapacity() {
        return this.buf.capacity();
    }

    private int flush() {
        if (!this.flushed) {
            this.checkpoint(this.lastCycle + 1L - this.runlength, this.lastCycle + 1L, this.lastResult);
            this.flushed = true;
        }
        return this.buf.position();
    }

    @Override
    public void close() {
        this.flush();
    }

    @Override
    public boolean onCycleResult(CycleResult cycleResult) {
        return this.onCycleResult(cycleResult.getCycle(), cycleResult.getResult());
    }
}

