/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.metrics;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.engineblock.activityapi.MetricRegistryService;
import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.metrics.DeltaHdrHistogramReservoir;
import io.engineblock.metrics.HistoIntervalLogger;
import io.engineblock.metrics.HistoStatsLogger;
import io.engineblock.metrics.MetricsCloseable;
import io.engineblock.metrics.NicerHistogram;
import io.engineblock.metrics.NicerTimer;
import io.engineblock.util.Unit;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.script.ScriptContext;
import org.HdrHistogram.Recorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityMetrics {
    private static final Logger logger = LoggerFactory.getLogger(ActivityMetrics.class);
    private static MetricRegistry registry;
    public static MetricFilter METRIC_FILTER;
    private static List<MetricsCloseable> metricsCloseables;

    private ActivityMetrics() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Metric register(ActivityDef activityDef, String name, MetricProvider metricProvider) {
        String fullMetricName = activityDef.getAlias() + "." + name;
        Metric metric = ActivityMetrics.get().getMetrics().get(fullMetricName);
        if (metric == null) {
            ActivityDef activityDef2 = activityDef;
            synchronized (activityDef2) {
                metric = ActivityMetrics.get().getMetrics().get(fullMetricName);
                if (metric == null) {
                    metric = metricProvider.getMetric();
                    return ActivityMetrics.get().register(fullMetricName, metric);
                }
            }
        }
        return metric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Metric register(ScriptContext context, String name, MetricProvider metricProvider) {
        Metric metric = ActivityMetrics.get().getMetrics().get(name);
        if (metric == null) {
            ScriptContext scriptContext = context;
            synchronized (scriptContext) {
                metric = ActivityMetrics.get().getMetrics().get(name);
                if (metric == null) {
                    metric = metricProvider.getMetric();
                    Metric registered = ActivityMetrics.get().register(name, metric);
                    logger.info("registered scripting metric: " + name);
                    return registered;
                }
            }
        }
        return metric;
    }

    public static Timer timer(ActivityDef activityDef, String name) {
        String fullMetricName = activityDef.getAlias() + "." + name;
        Timer registeredTimer = (Timer)ActivityMetrics.register(activityDef, name, () -> new NicerTimer(fullMetricName, new DeltaHdrHistogramReservoir(fullMetricName, new Recorder(4))));
        return registeredTimer;
    }

    public static Histogram histogram(ActivityDef activityDef, String name) {
        String fullMetricName = activityDef.getAlias() + "." + name;
        return (Histogram)ActivityMetrics.register(activityDef, name, () -> new NicerHistogram(fullMetricName, new DeltaHdrHistogramReservoir(fullMetricName, new Recorder(4))));
    }

    public static Counter counter(ActivityDef activityDef, String name) {
        return (Counter)ActivityMetrics.register(activityDef, name, Counter::new);
    }

    public static Meter meter(ActivityDef activityDef, String name) {
        return (Meter)ActivityMetrics.register(activityDef, name, Meter::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MetricRegistry get() {
        if (registry != null) {
            return registry;
        }
        Class<ActivityMetrics> clazz = ActivityMetrics.class;
        synchronized (ActivityMetrics.class) {
            if (registry == null) {
                registry = ActivityMetrics.lookupRegistry();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return registry;
        }
    }

    public static Gauge<?> gauge(ActivityDef activityDef, String name, Gauge<?> gauge) {
        return (Gauge)ActivityMetrics.register(activityDef, name, () -> gauge);
    }

    public static Gauge<?> gauge(ScriptContext scriptContext, String name, Gauge<?> gauge) {
        return (Gauge)ActivityMetrics.register(scriptContext, name, () -> gauge);
    }

    private static MetricRegistry lookupRegistry() {
        ServiceLoader<MetricRegistryService> metricRegistryServices = ServiceLoader.load(MetricRegistryService.class);
        ArrayList mrss = new ArrayList();
        metricRegistryServices.iterator().forEachRemaining(mrss::add);
        if (mrss.size() == 1) {
            return ((MetricRegistryService)mrss.get(0)).getMetricRegistry();
        }
        String infoMsg = "Unable to load a dynamic MetricRegistry via ServiceLoader, using the default.";
        logger.info(infoMsg);
        return new MetricRegistry();
    }

    public static MetricRegistry getMetricRegistry() {
        return ActivityMetrics.get();
    }

    public static void addHistoLogger(String sessionName, String pattern, String filename, String interval) {
        if (filename.contains("_SESSION_")) {
            filename = filename.replace("_SESSION_", sessionName);
        }
        Pattern compiledPattern = Pattern.compile(pattern);
        File logfile = new File(filename);
        long intervalMillis = Unit.msFor(interval).orElseThrow(() -> new RuntimeException("Unable to parse interval spec:'" + interval + "'"));
        HistoIntervalLogger histoIntervalLogger = new HistoIntervalLogger(sessionName, logfile, compiledPattern, intervalMillis);
        logger.debug("attaching " + histoIntervalLogger + " to the metrics registry.");
        ActivityMetrics.get().addListener(histoIntervalLogger);
        metricsCloseables.add(histoIntervalLogger);
    }

    public static void addStatsLogger(String sessionName, String pattern, String filename, String interval) {
        if (filename.contains("_SESSION_")) {
            filename = filename.replace("_SESSION_", sessionName);
        }
        Pattern compiledPattern = Pattern.compile(pattern);
        File logfile = new File(filename);
        long intervalMillis = Unit.msFor(interval).orElseThrow(() -> new RuntimeException("Unable to parse interval spec:" + interval + "'"));
        HistoStatsLogger histoStatsLogger = new HistoStatsLogger(sessionName, logfile, compiledPattern, intervalMillis, TimeUnit.NANOSECONDS);
        logger.debug("attaching " + histoStatsLogger + " to the metrics registry.");
        ActivityMetrics.get().addListener(histoStatsLogger);
        metricsCloseables.add(histoStatsLogger);
    }

    public static void closeMetrics() {
        logger.trace("Closing all registered metrics closable objects.");
        for (MetricsCloseable metricsCloseable : metricsCloseables) {
            logger.trace("closing metrics closeable: " + metricsCloseable);
            metricsCloseable.closeMetrics();
        }
    }

    public static void reportTo(PrintStream out) {
        out.println("====================  BEGIN-METRIC-LOG  ====================");
        ConsoleReporter consoleReporter = ConsoleReporter.forRegistry(ActivityMetrics.getMetricRegistry()).convertDurationsTo(TimeUnit.MICROSECONDS).convertRatesTo(TimeUnit.SECONDS).filter(MetricFilter.ALL).outputTo(out).build();
        consoleReporter.report();
        out.println("====================   END-METRIC-LOG   ====================");
    }

    static {
        METRIC_FILTER = (name, metric) -> true;
        metricsCloseables = new ArrayList<MetricsCloseable>();
    }

    private static interface MetricProvider {
        public Metric getMetric();
    }
}

