/*
 * Decompiled with CFR 0.152.
 */
package activityconfig;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MultiMapLookup
implements Map<String, String> {
    private final List<Map<String, String>> maps = new ArrayList<Map<String, String>>();

    public MultiMapLookup() {
    }

    public MultiMapLookup(Map<String, String> map1, Map<String, String> map2) {
        this.add(map1);
        this.add(map2);
    }

    public MultiMapLookup add(Map<String, String> map) {
        this.maps.add(map);
        return this;
    }

    @Override
    public int size() {
        long count = this.maps.stream().map(Map::keySet).flatMap(Collection::stream).distinct().count();
        return new Long(count).intValue();
    }

    @Override
    public boolean isEmpty() {
        return this.maps.stream().allMatch(Map::isEmpty);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.maps.stream().anyMatch(m -> m.containsKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.maps.stream().anyMatch(m -> m.containsValue(value));
    }

    @Override
    public String get(Object key) {
        return this.maps.stream().filter(m -> m.containsKey(String.valueOf(key))).findFirst().map(m -> String.valueOf(m.get(key))).orElse(null);
    }

    @Override
    public String put(String key, String value) {
        throw this.immutable();
    }

    @Override
    public String remove(Object key) {
        throw this.immutable();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        throw this.immutable();
    }

    @Override
    public void clear() {
        throw this.immutable();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        this.maps.stream().map(Map::keySet).flatMap(Collection::stream).forEach(keys::add);
        return keys;
    }

    @Override
    public Collection<String> values() {
        return this.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        HashMap<String, String> compositeMap = new HashMap<String, String>();
        for (Map<String, String> map : this.maps) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (compositeMap.containsKey(entry.getKey())) continue;
                compositeMap.put(entry.getKey(), entry.getValue());
            }
        }
        return compositeMap.entrySet();
    }

    private RuntimeException immutable() {
        return new RuntimeException("This map is not meant to be mutable.");
    }

    public String toString() {
        return this.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.joining(","));
    }
}

