/*
 * Decompiled with CFR 0.152.
 */
package activityconfig.rawyaml;

import activityconfig.rawyaml.RawStmtsBlock;
import activityconfig.rawyaml.RawStmtsDoc;
import activityconfig.rawyaml.RawStmtsDocList;
import activityconfig.rawyaml.StatementsOwner;
import activityconfig.snakecharmer.SnakeYamlCharmer;
import io.engineblock.activityimpl.ActivityInitializationError;
import io.engineblock.util.EngineBlockFiles;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdk.nashorn.internal.runtime.ParserException;
import org.slf4j.Logger;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;

public class RawYamlStatementLoader {
    List<Function<String, String>> stringTransformers = new ArrayList<Function<String, String>>();

    public RawYamlStatementLoader() {
    }

    public RawYamlStatementLoader(Function<String, String> stringTransformer) {
        this.addTransformer(stringTransformer);
    }

    public RawStmtsDocList load(Logger logger, String fromPath, String ... searchPaths) {
        String data = this.loadRawFile(logger, fromPath, searchPaths);
        data = this.applyTransforms(logger, data);
        return this.parseYaml(logger, data);
    }

    public void addTransformer(Function<String, String> transformer) {
        this.stringTransformers.add(transformer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String loadRawFile(Logger logger, String fromPath, String ... searchPaths) {
        InputStream stream = EngineBlockFiles.findRequiredStreamOrFile(fromPath, "yaml", searchPaths);
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(stream));){
            String string = buffer.lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while reading YAML from search paths:" + Arrays.toString(searchPaths) + ":" + e.getMessage(), e);
        }
    }

    protected String applyTransforms(Logger logger, String data) {
        for (Function<String, String> xform : this.stringTransformers) {
            try {
                if (logger != null) {
                    logger.debug("Applying string transformer to yaml data:" + xform);
                }
                data = xform.apply(data);
            }
            catch (Exception e) {
                ActivityInitializationError t = new ActivityInitializationError("Error applying string applyTransforms to input", e);
                if (logger != null) {
                    logger.error(t.getMessage(), (Throwable)t);
                }
                throw t;
            }
        }
        return data;
    }

    protected RawStmtsDocList parseYaml(Logger logger, String data) {
        Yaml yaml = this.getCustomYaml();
        try {
            Iterable objects = yaml.loadAll(data);
            ArrayList<RawStmtsDoc> stmtListList = new ArrayList<RawStmtsDoc>();
            for (Object object : objects) {
                RawStmtsDoc tgsd = (RawStmtsDoc)object;
                stmtListList.add(tgsd);
            }
            return new RawStmtsDocList(stmtListList);
        }
        catch (ParserException pe) {
            if (logger != null) {
                logger.error("yaml-parsing-error: Error parsing YAML:" + pe.getMessage() + " For more details on this error see http://docs.engineblock.io/user-guide/standard_yaml/#yaml-parsing-error", (Throwable)pe);
            }
            throw pe;
        }
        catch (Exception e) {
            if (logger != null) {
                logger.error("yaml-construction-error: Error building configuration:" + e.getMessage() + " For more details on this error see http://docs.engineblock.io/user-guide/standard_yaml/#yaml-construction-error", (Throwable)e);
            }
            throw e;
        }
    }

    protected Yaml getCustomYaml() {
        SnakeYamlCharmer charmer = new SnakeYamlCharmer(RawStmtsDoc.class);
        charmer.addHandler(StatementsOwner.class, "statements", new StatementsReader());
        charmer.addHandler(StatementsOwner.class, "statement", new StatementsReader());
        TypeDescription tds = new TypeDescription(RawStmtsDoc.class);
        tds.addPropertyParameters("blocks", new Class[]{RawStmtsBlock.class});
        charmer.addTypeDescription(tds);
        return new Yaml((BaseConstructor)charmer);
    }

    protected RawStmtsDocList loadString(Logger logger, String rawYaml) {
        String data = this.applyTransforms(logger, rawYaml);
        return this.parseYaml(logger, data);
    }

    private class StatementsReader
    implements SnakeYamlCharmer.FieldHandler {
        private StatementsReader() {
        }

        @Override
        public void handleMapping(Object object, Object nodeTuple) {
            if (object instanceof StatementsOwner) {
                ((StatementsOwner)object).setByObject(nodeTuple);
            }
        }
    }
}

