/*
 * Decompiled with CFR 0.152.
 */
package activityconfig.yaml;

import activityconfig.rawyaml.RawStmtsDocList;
import activityconfig.yaml.StmtDef;
import activityconfig.yaml.StmtsDoc;
import io.engineblock.util.TagFilter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StmtsDocList
implements Iterable<StmtsDoc> {
    private RawStmtsDocList rawStmtsDocList;

    public StmtsDocList(RawStmtsDocList rawStmtsDocList) {
        this.rawStmtsDocList = rawStmtsDocList;
    }

    public List<StmtsDoc> getStmtDocs(String tagFilter) {
        TagFilter tf = new TagFilter(tagFilter);
        return this.getStmtDocs().stream().filter(tf::matchesTagged).collect(Collectors.toList());
    }

    public List<StmtsDoc> getStmtDocs() {
        return this.rawStmtsDocList.getStmtsDocs().stream().map(StmtsDoc::new).collect(Collectors.toList());
    }

    public List<StmtDef> getStmts() {
        return this.getStmts("");
    }

    public List<StmtDef> getStmts(String tagFilterSpec) {
        TagFilter ts = new TagFilter(tagFilterSpec);
        List<StmtDef> stmts = this.getStmtDocs().stream().flatMap(d -> d.getStmts().stream()).filter(ts::matchesTagged).collect(Collectors.toList());
        return stmts;
    }

    @Override
    public Iterator<StmtsDoc> iterator() {
        return this.getStmtDocs().iterator();
    }

    public Map<String, String> getDocBindings() {
        LinkedHashMap<String, String> docBindings = new LinkedHashMap<String, String>();
        this.getStmtDocs().stream().map(StmtsDoc::getBindings).forEach(docBindings::putAll);
        return docBindings;
    }
}

