/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.core.ops;

import io.engineblock.activityapi.core.ops.OpContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class BaseOpContext
implements OpContext {
    private static final OpContext.OpEvents NULLSINK = new NullOpEvents();
    private static AtomicLong idgen = new AtomicLong(0L);
    public final long ctxid = idgen.getAndIncrement();
    private long usages = 0L;
    private OpContext.OpEvents nullHandler = NULLSINK;
    private long delayNanos;
    private long startedAtNanos = 0L;
    private long endedAtNanos = 0L;
    private long cycle;
    private int result;
    private int tries = 0;
    private List<OpContext.OpEvents> opEvents = new ArrayList<OpContext.OpEvents>();

    @Override
    public OpContext reset() {
        for (OpContext.OpEvents opEvents : this.opEvents) {
            opEvents.onOpReset(this);
        }
        this.startedAtNanos = 0L;
        this.delayNanos = 0L;
        this.endedAtNanos = 0L;
        this.cycle = 0L;
        this.result = 0;
        this.opEvents = null;
        this.opEvents.clear();
        return this;
    }

    @Override
    public OpContext addSink(OpContext.OpEvents opEvents) {
        this.opEvents.add(opEvents);
        return this;
    }

    @Override
    public OpContext setWaitTime(long delayNanos) {
        this.endedAtNanos = Long.MIN_VALUE;
        this.cycle = this.cycle;
        this.delayNanos = delayNanos;
        this.startedAtNanos = System.nanoTime();
        ++this.usages;
        return this;
    }

    @Override
    public OpContext start() {
        this.endedAtNanos = Long.MIN_VALUE;
        this.startedAtNanos = System.nanoTime();
        this.tries = 1;
        ++this.usages;
        for (OpContext.OpEvents opEvents : this.opEvents) {
            opEvents.onOpStart(this);
        }
        return this;
    }

    @Override
    public OpContext retry() {
        this.startedAtNanos = System.nanoTime();
        this.endedAtNanos = Long.MIN_VALUE;
        ++this.usages;
        ++this.tries;
        for (OpContext.OpEvents opEvents : this.opEvents) {
            opEvents.onOpRestart(this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OpContext stop(int result) {
        this.endedAtNanos = System.nanoTime();
        this.result = result;
        for (OpContext.OpEvents opEvents : this.opEvents) {
            opEvents.onAfterOpStop(this);
        }
        BaseOpContext baseOpContext = this;
        synchronized (baseOpContext) {
            this.notifyAll();
        }
        return this;
    }

    @Override
    public long getFinalServiceTime() {
        return this.endedAtNanos - this.startedAtNanos;
    }

    @Override
    public long getCumulativeServiceTime() {
        return System.nanoTime() - this.startedAtNanos;
    }

    @Override
    public long getFinalResponseTime() {
        return this.delayNanos + (this.endedAtNanos - this.startedAtNanos);
    }

    @Override
    public long getCumulativeResponseTime() {
        return this.delayNanos + (System.nanoTime() - this.startedAtNanos);
    }

    @Override
    public long getWaitTime() {
        return this.delayNanos;
    }

    @Override
    public int getResult() {
        return this.result;
    }

    @Override
    public int getTries() {
        return this.tries;
    }

    @Override
    public long getCycle() {
        return this.cycle;
    }

    @Override
    public long getCtxId() {
        return this.ctxid;
    }

    @Override
    public boolean isRunning() {
        return this.endedAtNanos < 0L;
    }

    public String toString() {
        return "BasicOpContext{(S-state,I-id,C-cycle,T-tries,U-use)=(S-" + (this.startedAtNanos <= 0L ? "RESET" : (this.endedAtNanos <= 0L ? "RUNNING" : "STOPPED")) + ",I-" + this.ctxid + ",C-" + this.cycle + ",T-" + this.tries + ",U-" + this.usages + "), result=" + this.result + ", delayNanos=" + this.delayNanos + ", startedAtNanos=" + this.startedAtNanos + ", endedAtNanos=" + this.endedAtNanos + ", usages=" + this.usages + ", opEvents=" + this.opEvents.size() + '}';
    }

    @Override
    public void setCycle(long cycle) {
        this.cycle = cycle;
    }

    private static final class NullOpEvents
    implements OpContext.OpEvents {
        private NullOpEvents() {
        }
    }
}

