/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.rates;

import com.codahale.metrics.Gauge;
import io.engineblock.activityapi.core.Startable;
import io.engineblock.activityapi.rates.RateLimiter;
import io.engineblock.activityapi.rates.RateLimiters;
import io.engineblock.activityapi.rates.RateSpec;
import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.metrics.ActivityMetrics;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AverageRateLimiter
implements Startable,
RateLimiter {
    private static final Logger logger = LoggerFactory.getLogger(AverageRateLimiter.class);
    private String label;
    private ActivityDef activityDef;
    private RateSpec rateSpec;
    private long opTicks = 0L;
    protected final AtomicLong ticksTimeline = new AtomicLong(0L);
    private final AtomicLong accumulatedDelayNanos = new AtomicLong(0L);
    private volatile long lastSeenNanoTime;
    private volatile boolean isBursting = false;
    private State state = State.Idle;
    private boolean reportCoDelay = false;
    private Gauge<Long> delayGauge;
    private Gauge<Double> avgRateGauge;

    protected AverageRateLimiter() {
    }

    public AverageRateLimiter(ActivityDef def, String label, RateSpec rateSpec) {
        this.setActivityDef(def);
        this.setLabel(label);
        this.setRateSpec(rateSpec);
        this.init();
    }

    protected void setLabel(String label) {
        this.label = label;
    }

    protected void setActivityDef(ActivityDef def) {
        this.activityDef = def;
    }

    protected void init() {
        this.delayGauge = ActivityMetrics.gauge(this.activityDef, this.label + ".cco_delay_gauge", new RateLimiters.DelayGauge(this));
        this.avgRateGauge = ActivityMetrics.gauge(this.activityDef, this.label + ".avg_targetrate_gauge", new RateLimiters.RateGauge(this));
        this.start();
    }

    protected long getNanoClockTime() {
        return System.nanoTime();
    }

    @Override
    public long acquire(long nanos) {
        long timelinePosition;
        long opScheduleTime = this.ticksTimeline.getAndAdd(nanos);
        if (opScheduleTime < (timelinePosition = this.lastSeenNanoTime)) {
            this.isBursting = true;
            return this.reportCoDelay ? timelinePosition - opScheduleTime : 0L;
        }
        long delay = timelinePosition - opScheduleTime;
        if (delay <= 0L) {
            this.lastSeenNanoTime = timelinePosition = this.getNanoClockTime();
            delay = timelinePosition - opScheduleTime;
            if (delay < 0L) {
                this.isBursting = false;
                delay *= -1L;
                try {
                    Thread.sleep(delay / 1000000L, (int)(delay % 1000000L));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return 0L;
            }
        }
        return this.reportCoDelay ? delay : 0L;
    }

    @Override
    public long acquire() {
        return this.acquire(this.opTicks);
    }

    @Override
    public long getOpNanos() {
        return this.opTicks;
    }

    @Override
    public double getRate() {
        return this.rateSpec.opsPerSec;
    }

    @Override
    public synchronized void setRate(double rate) {
        this.setRateSpec(this.rateSpec.withOpsPerSecond(rate));
    }

    @Override
    public long getTotalSchedulingDelay() {
        return this.getRateSchedulingDelay() + this.accumulatedDelayNanos.get();
    }

    protected long getRateSchedulingDelay() {
        return this.getNanoClockTime() - this.ticksTimeline.get();
    }

    @Override
    public synchronized void start() {
        switch (this.state) {
            case Started: {
                break;
            }
            case Idle: {
                this.sync();
                this.state = State.Started;
            }
        }
    }

    private synchronized void sync() {
        long nanos;
        this.lastSeenNanoTime = nanos = this.getNanoClockTime();
        switch (this.state) {
            case Idle: {
                this.ticksTimeline.set(nanos);
                this.accumulatedDelayNanos.set(0L);
                break;
            }
            case Started: {
                this.accumulatedDelayNanos.addAndGet(this.getRateSchedulingDelay());
            }
        }
    }

    public String toString() {
        return "spec=[" + this.label + "]:" + this.rateSpec.toString() + ", delay=" + this.getRateSchedulingDelay() + ", total=" + this.getTotalSchedulingDelay() + ", (used/seen)=(" + this.ticksTimeline.get() + "/" + this.lastSeenNanoTime + "), (clock,actual)=(" + this.getNanoClockTime() + "," + System.nanoTime() + ")";
    }

    @Override
    public RateSpec getRateSpec() {
        return this.rateSpec;
    }

    @Override
    public void setRateSpec(RateSpec updatingRateSpec) {
        RateSpec oldRateSpec = this.rateSpec;
        this.rateSpec = updatingRateSpec;
        if (oldRateSpec != null && oldRateSpec.equals(this.rateSpec)) {
            return;
        }
        this.reportCoDelay = updatingRateSpec.getReportCoDelay();
        this.opTicks = updatingRateSpec.getCalculatedNanos();
        this.rateSpec = updatingRateSpec;
        switch (this.state) {
            case Started: {
                this.sync();
            }
        }
    }

    public AtomicLong getTicksTimeline() {
        return this.ticksTimeline;
    }

    public long getLastSeenNanoTimeline() {
        return this.lastSeenNanoTime;
    }

    private static enum State {
        Idle,
        Started;

    }
}

