/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityapi.rates;

import com.codahale.metrics.Gauge;
import io.engineblock.activityapi.rates.AverageRateLimiter;
import io.engineblock.activityapi.rates.RateLimiter;
import io.engineblock.activityapi.rates.RateSpec;
import io.engineblock.activityimpl.ActivityDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimiters {
    private static final Logger logger = LoggerFactory.getLogger(RateLimiters.class);

    public static synchronized RateLimiter createOrUpdate(ActivityDef def, String label, RateLimiter extant, RateSpec spec) {
        if (extant == null) {
            logger.info("Using average rate limiter for speed: " + spec);
            return new AverageRateLimiter(def, label, spec);
        }
        extant.setRateSpec(spec);
        return extant;
    }

    public static synchronized RateLimiter create(ActivityDef def, String label, String specString) {
        return RateLimiters.createOrUpdate(def, label, null, new RateSpec(specString));
    }

    public static class BurstRateGauge
    implements Gauge<Double> {
        private final RateLimiter rateLimiter;

        public BurstRateGauge(RateLimiter rateLimiter) {
            this.rateLimiter = rateLimiter;
        }

        public Double getValue() {
            return this.rateLimiter.getRateSpec().getBurstRatio() * this.rateLimiter.getRateSpec().getRate();
        }
    }

    public static class RateGauge
    implements Gauge<Double> {
        private final RateLimiter rateLimiter;

        public RateGauge(RateLimiter rateLimiter) {
            this.rateLimiter = rateLimiter;
        }

        public Double getValue() {
            return this.rateLimiter.getRateSpec().opsPerSec;
        }
    }

    public static class DelayGauge
    implements Gauge<Long> {
        private final RateLimiter rateLimiter;

        public DelayGauge(RateLimiter rateLimiter) {
            this.rateLimiter = rateLimiter;
        }

        public Long getValue() {
            return this.rateLimiter.getTotalSchedulingDelay();
        }
    }
}

