/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityimpl;

import io.engineblock.activityapi.core.ActionDispenser;
import io.engineblock.activityapi.core.Activity;
import io.engineblock.activityapi.core.ActivityController;
import io.engineblock.activityapi.core.MotorDispenser;
import io.engineblock.activityapi.core.RunState;
import io.engineblock.activityapi.cyclelog.filters.IntPredicateDispenser;
import io.engineblock.activityapi.input.InputDispenser;
import io.engineblock.activityapi.output.OutputDispenser;
import io.engineblock.activityapi.rates.RateLimiter;
import io.engineblock.activityapi.rates.RateLimiters;
import io.engineblock.activityapi.rates.RateSpec;
import io.engineblock.activityimpl.ActivityDef;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleActivity
implements Activity {
    private static final Logger logger = LoggerFactory.getLogger(SimpleActivity.class);
    protected ActivityDef activityDef;
    private List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private MotorDispenser motorDispenser;
    private InputDispenser inputDispenser;
    private ActionDispenser actionDispenser;
    private OutputDispenser markerDispenser;
    private IntPredicateDispenser resultFilterDispenser;
    private RunState runState = RunState.Uninitialized;
    private RateLimiter strideLimiter;
    private RateLimiter cycleLimiter;
    private RateLimiter phaseLimiter;
    private ActivityController activityController;

    public SimpleActivity(ActivityDef activityDef) {
        this.activityDef = activityDef;
    }

    public SimpleActivity(String activityDefString) {
        this(ActivityDef.parseActivityDef(activityDefString));
    }

    @Override
    public void initActivity() {
        this.onActivityDefUpdate(this.activityDef);
    }

    @Override
    public synchronized RunState getRunState() {
        return this.runState;
    }

    @Override
    public synchronized void setRunState(RunState runState) {
        this.runState = runState;
    }

    @Override
    public final MotorDispenser getMotorDispenserDelegate() {
        return this.motorDispenser;
    }

    @Override
    public final void setMotorDispenserDelegate(MotorDispenser motorDispenser) {
        this.motorDispenser = motorDispenser;
    }

    @Override
    public final InputDispenser getInputDispenserDelegate() {
        return this.inputDispenser;
    }

    @Override
    public final void setInputDispenserDelegate(InputDispenser inputDispenser) {
        this.inputDispenser = inputDispenser;
    }

    @Override
    public final ActionDispenser getActionDispenserDelegate() {
        return this.actionDispenser;
    }

    @Override
    public final void setActionDispenserDelegate(ActionDispenser actionDispenser) {
        this.actionDispenser = actionDispenser;
    }

    @Override
    public IntPredicateDispenser getResultFilterDispenserDelegate() {
        return this.resultFilterDispenser;
    }

    @Override
    public void setResultFilterDispenserDelegate(IntPredicateDispenser resultFilterDispenser) {
        this.resultFilterDispenser = resultFilterDispenser;
    }

    @Override
    public OutputDispenser getMarkerDispenserDelegate() {
        return this.markerDispenser;
    }

    @Override
    public void setOutputDispenserDelegate(OutputDispenser outputDispenser) {
        this.markerDispenser = outputDispenser;
    }

    @Override
    public ActivityDef getActivityDef() {
        return this.activityDef;
    }

    public String toString() {
        return this.getAlias();
    }

    @Override
    public int compareTo(Activity o) {
        return this.getAlias().compareTo(o.getAlias());
    }

    @Override
    public void setActivityController(ActivityController activityController) {
        this.activityController = activityController;
    }

    @Override
    public ActivityController getActivityController() {
        return this.activityController;
    }

    @Override
    public void registerAutoCloseable(AutoCloseable closeable) {
        this.closeables.add(closeable);
    }

    @Override
    public void closeAutoCloseables() {
        for (AutoCloseable closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Error closing " + closeable);
            }
        }
        this.closeables.clear();
    }

    @Override
    public RateLimiter getCycleLimiter() {
        return this.cycleLimiter;
    }

    @Override
    public synchronized void setCycleLimiter(RateLimiter rateLimiter) {
        this.cycleLimiter = rateLimiter;
    }

    @Override
    public synchronized RateLimiter getCycleRateLimiter(Supplier<? extends RateLimiter> s) {
        if (this.cycleLimiter == null) {
            this.cycleLimiter = s.get();
        }
        return this.cycleLimiter;
    }

    @Override
    public synchronized RateLimiter getStrideLimiter() {
        return this.strideLimiter;
    }

    @Override
    public synchronized void setStrideLimiter(RateLimiter rateLimiter) {
        this.strideLimiter = rateLimiter;
    }

    @Override
    public synchronized RateLimiter getStrideRateLimiter(Supplier<? extends RateLimiter> s) {
        if (this.strideLimiter == null) {
            this.strideLimiter = s.get();
        }
        return this.strideLimiter;
    }

    @Override
    public RateLimiter getPhaseLimiter() {
        return this.phaseLimiter;
    }

    @Override
    public void setPhaseLimiter(RateLimiter rateLimiter) {
        this.phaseLimiter = this.phaseLimiter;
    }

    @Override
    public synchronized RateLimiter getPhaseRateLimiter(Supplier<? extends RateLimiter> supplier) {
        if (this.phaseLimiter == null) {
            this.phaseLimiter = supplier.get();
        }
        return this.phaseLimiter;
    }

    @Override
    public synchronized void onActivityDefUpdate(ActivityDef activityDef) {
        activityDef.getParams().getOptionalNamedParameter("striderate", "co_striderate").map(RateSpec::new).ifPresent(spec -> {
            this.strideLimiter = RateLimiters.createOrUpdate(this.getActivityDef(), "stride", this.strideLimiter, spec);
        });
        activityDef.getParams().getOptionalNamedParameter("cyclerate", "co_cyclerate", "targetrate", "co_targetrate").map(RateSpec::new).ifPresent(spec -> {
            this.cycleLimiter = RateLimiters.createOrUpdate(this.getActivityDef(), "cycle", this.cycleLimiter, spec);
        });
        activityDef.getParams().getOptionalNamedParameter("phaserate", "co_phaserate").map(RateSpec::new).ifPresent(spec -> {
            this.phaseLimiter = RateLimiters.createOrUpdate(this.getActivityDef(), "phase", this.phaseLimiter, spec);
        });
    }
}

