/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricRegistryListener;
import com.codahale.metrics.Timer;

public class MetricsRegistryMount
implements MetricRegistryListener {
    private final MetricRegistry owningRegistry;
    private final MetricRegistry mountedRegistry;
    private final String mountedPrefix;

    public MetricsRegistryMount(MetricRegistry owningRegistry, MetricRegistry mountedRegistry, String mountedPrefix) {
        this.owningRegistry = owningRegistry;
        this.mountedRegistry = mountedRegistry;
        this.mountedPrefix = mountedPrefix;
        mountedRegistry.addListener((MetricRegistryListener)this);
    }

    public void onGaugeAdded(String name, Gauge<?> gauge) {
        this.owningRegistry.register(this.mountedPrefix + name, gauge);
    }

    public void onGaugeRemoved(String name) {
        this.owningRegistry.remove(this.mountedPrefix + name);
    }

    public void onCounterAdded(String name, Counter counter) {
        this.owningRegistry.register(this.mountedPrefix + name, (Metric)counter);
    }

    public void onCounterRemoved(String name) {
        this.owningRegistry.remove(this.mountedPrefix + name);
    }

    public void onHistogramAdded(String name, Histogram histogram) {
        this.owningRegistry.register(this.mountedPrefix + name, (Metric)histogram);
    }

    public void onHistogramRemoved(String name) {
        this.owningRegistry.remove(this.mountedPrefix + name);
    }

    public void onMeterAdded(String name, Meter meter) {
        this.owningRegistry.register(this.mountedPrefix + name, (Metric)meter);
    }

    public void onMeterRemoved(String name) {
        this.owningRegistry.remove(this.mountedPrefix + name);
    }

    public void onTimerAdded(String name, Timer timer) {
        this.owningRegistry.register(this.mountedPrefix + name, (Metric)timer);
    }

    public void onTimerRemoved(String name) {
        this.owningRegistry.remove(this.mountedPrefix + name);
    }
}

