/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.scripting;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.script.SimpleScriptContext;

public class ScriptEnvBuffer
extends SimpleScriptContext {
    private DiagWriter stdoutBuffer;
    private DiagWriter stderrBuffer;
    private DiagReader stdinBuffer;
    private DateTimeFormatter tsformat = DateTimeFormatter.ISO_DATE_TIME;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer getWriter() {
        if (this.stdoutBuffer == null) {
            ScriptEnvBuffer scriptEnvBuffer = this;
            synchronized (scriptEnvBuffer) {
                if (this.stdoutBuffer == null) {
                    Writer superWriter = super.getWriter();
                    this.stdoutBuffer = new DiagWriter(superWriter, " stdout ");
                }
            }
        }
        return this.stdoutBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Writer getErrorWriter() {
        if (this.stderrBuffer == null) {
            ScriptEnvBuffer scriptEnvBuffer = this;
            synchronized (scriptEnvBuffer) {
                if (this.stderrBuffer == null) {
                    Writer superErrorWriter = super.getErrorWriter();
                    this.stderrBuffer = new DiagWriter(superErrorWriter, " error ");
                }
            }
        }
        return this.stderrBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getReader() {
        if (this.stdinBuffer == null) {
            ScriptEnvBuffer scriptEnvBuffer = this;
            synchronized (scriptEnvBuffer) {
                if (this.stdinBuffer == null) {
                    Reader superReader = super.getReader();
                    this.stdinBuffer = new DiagReader(superReader, " stdin ");
                }
            }
        }
        return this.stdinBuffer;
    }

    public String getStdinText() {
        return this.stdinBuffer.buffer.toString();
    }

    public String getStderrText() {
        return this.stderrBuffer.buffer.toString();
    }

    public String getStdoutText() {
        return this.stdoutBuffer.buffer.toString();
    }

    public List<String> getTimeLogLines() {
        ArrayList<String> log = new ArrayList();
        Optional.ofNullable(this.stdinBuffer).map(t -> ((DiagReader)t).timedLog).ifPresent(log::addAll);
        Optional.ofNullable(this.stderrBuffer).map(t -> ((DiagWriter)t).timedLog).ifPresent(log::addAll);
        Optional.ofNullable(this.stdoutBuffer).map(t -> ((DiagWriter)t).timedLog).ifPresent(log::addAll);
        log = log.stream().map(l -> l + "\n").collect(Collectors.toList());
        return log;
    }

    public String getTimedLog() {
        return this.getTimeLogLines().stream().collect(Collectors.joining());
    }

    private class DiagWriter
    extends Writer {
        Writer wrapped;
        private final String prefix;
        CharArrayWriter buffer = new CharArrayWriter();
        private List<String> timedLog = new ArrayList<String>();

        public DiagWriter(Writer wrapped, String prefix) {
            this.wrapped = wrapped;
            this.prefix = prefix;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            String tsprefix = LocalDateTime.now().format(ScriptEnvBuffer.this.tsformat);
            this.buffer.write(cbuf, off, len);
            String text = new String(cbuf, off, len);
            if (!text.equals("\n")) {
                String tslogEntry = tsprefix + this.prefix + new String(cbuf, off, len);
                this.timedLog.add(tslogEntry);
            }
            this.wrapped.write(cbuf, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.buffer.flush();
            this.wrapped.flush();
        }

        @Override
        public void close() throws IOException {
            this.buffer.close();
            this.wrapped.close();
        }
    }

    private class DiagReader
    extends Reader {
        Reader wrapped;
        private final String prefix;
        CharArrayWriter buffer = new CharArrayWriter(0);
        private List<String> timedLog = new ArrayList<String>();

        public DiagReader(Reader wrapped, String prefix) {
            this.wrapped = wrapped;
            this.prefix = prefix;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            String tsprefix = LocalDateTime.now().format(ScriptEnvBuffer.this.tsformat);
            int read = this.wrapped.read(cbuf, off, len);
            this.buffer.write(cbuf, off, len);
            this.timedLog.add(tsprefix + this.prefix + new String(cbuf, off, len));
            return read;
        }

        @Override
        public void close() throws IOException {
            this.wrapped.close();
            this.buffer.close();
        }
    }
}

