/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.util;

import io.engineblock.activityimpl.ActivityDef;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SSLKsFactory {
    private static SSLKsFactory instance = new SSLKsFactory();

    private SSLKsFactory() {
    }

    public static SSLKsFactory get() {
        return instance;
    }

    public ServerSocketFactory createSSLServerSocketFactory(ActivityDef def) {
        return this.getContext(def).getServerSocketFactory();
    }

    public SocketFactory createSocketFactory(ActivityDef def) {
        return this.getContext(def).getSocketFactory();
    }

    public SSLContext getContext(ActivityDef def) {
        String keystorePath = def.getParams().getOptionalString("keystore").orElse("JKS");
        String keystorePass = def.getParams().getOptionalString("kspass").orElse("NONE");
        String tlsVersion = def.getParams().getOptionalString("tlsversion").orElse("TLSv1.2");
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(keystorePath), keystorePass.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, keystorePass.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            SSLContext sc = SSLContext.getInstance(tlsVersion);
            sc.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            return sc;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

