/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.util;

import io.engineblock.util.Named;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleServiceLoader<T extends Named> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleServiceLoader.class);
    private Class<? extends T> serviceType;
    private static SimpleServiceLoader instance;
    private final Map<String, T> types = new ConcurrentHashMap<String, T>();

    public SimpleServiceLoader(Class<? extends T> serviceType) {
        this.serviceType = serviceType;
    }

    public Optional<T> get(String implName) {
        return Optional.ofNullable(this.getTypes().get(implName));
    }

    public T getOrThrow(String implName) {
        Optional<T> at = Optional.ofNullable(this.getTypes().get(implName));
        return (T)((Named)at.orElseThrow(() -> new RuntimeException(this.serviceType.getSimpleName() + " '" + implName + "' not found. Available types:" + this.getTypes().keySet().stream().collect(Collectors.joining(",")))));
    }

    private synchronized Map<String, T> getTypes() {
        if (this.types.size() == 0) {
            ClassLoader cl = this.getClass().getClassLoader();
            logger.debug("loading service types for " + this.serviceType.getSimpleName());
            ServiceLoader<Named> sl = ServiceLoader.load(this.serviceType);
            try {
                for (Named inputType : sl) {
                    if (this.types.get(inputType.getName()) != null) {
                        throw new RuntimeException("ActivityType '" + inputType.getName() + "' is already defined.");
                    }
                    this.types.put(inputType.getName(), inputType);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        logger.info("Loaded Types:" + this.types.keySet());
        return this.types;
    }

    public List<T> getAll() {
        ArrayList<T> types = new ArrayList<T>(this.getTypes().values());
        types.sort(Comparator.comparing(Named::getName));
        return Collections.unmodifiableList(types);
    }
}

