/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.util;

import io.engineblock.activityimpl.ActivityDef;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.text.StrLookup;
import org.apache.commons.text.StrSubstitutor;

public class StrInterpolater
implements Function<String, String> {
    private MultiMap multimap = new MultiMap();
    private StrSubstitutor substitutor = new StrSubstitutor((StrLookup)this.multimap, "<<", ">>", '\\');
    private StrSubstitutor substitutor2 = new StrSubstitutor((StrLookup)this.multimap, "TEMPLATE(", ")", '\\');

    public StrInterpolater(ActivityDef ... activityDefs) {
        Arrays.stream(activityDefs).map(ad -> ad.getParams().getStringStringMap()).forEach(this.multimap::add);
    }

    public StrInterpolater(Map<String, String> basicMap) {
        this.multimap.add(basicMap);
    }

    protected StrInterpolater(List<Map<String, String>> maps) {
        maps.forEach(this.multimap::add);
    }

    @Override
    public String apply(String s) {
        return this.substitutor.replace(this.substitutor2.replace(s));
    }

    private static class MultiMap
    extends StrLookup<String> {
        private List<Map<String, String>> maps = new ArrayList<Map<String, String>>();
        private String warnPrefix = "UNSET";

        private MultiMap() {
        }

        public void add(Map<String, String> addedMap) {
            this.maps.add(addedMap);
        }

        public String lookup(String key) {
            String defval = null;
            String[] parts = key.split("[:,]", 2);
            if (parts.length == 2) {
                key = parts[0];
                defval = parts[1];
            }
            for (Map<String, String> map : this.maps) {
                String val = map.get(key);
                if (val == null) continue;
                return val;
            }
            return defval != null ? defval : this.warnPrefix + ":" + key;
        }
    }
}

