/*
 *
 *    Copyright 2016 jshook
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 * /
 */

package io.engineblock.activityapi.cyclelog.filters;

import io.engineblock.activityapi.core.Activity;
import io.engineblock.util.Named;
import io.engineblock.util.SimpleConfig;
import io.engineblock.util.SimpleServiceLoader;

import java.util.function.IntPredicate;

public interface ExperimentalResultFilterType extends Named {

    public static SimpleServiceLoader<ExperimentalResultFilterType> FINDER =
            new SimpleServiceLoader<>(ExperimentalResultFilterType.class);

    default IntPredicateDispenser getFilterDispenser(Activity activity) {
        SimpleConfig conf = new SimpleConfig(activity, "resultfilter");
        return getFilterDispenser(conf);
    }

    default IntPredicateDispenser getFilterDispenser(SimpleConfig conf) {
        IntPredicate intPredicate = getIntPredicate(conf);
        return new StaticDispenser(intPredicate);
    }

    IntPredicate getIntPredicate(SimpleConfig conf);

    public static class StaticDispenser implements IntPredicateDispenser {

        private final IntPredicate predicate;

        public StaticDispenser(IntPredicate predicate) {
            this.predicate = predicate;
        }

        @Override
        public IntPredicate getIntPredicate(int slot) {
            return predicate;
        }
    }
}
