/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.cli;

import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.cli.EBCLIOptions;
import io.engineblock.util.EngineBlockFiles;
import io.engineblock.util.StrInterpolater;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBCLIScriptAssembly {
    private static final Logger logger = LoggerFactory.getLogger(EBCLIScriptAssembly.class);

    public static String assembleScript(EBCLIOptions options) {
        StringBuilder sb = new StringBuilder();
        for (EBCLIOptions.Cmd cmd : options.getCommands()) {
            switch (cmd.cmdType) {
                case script: {
                    String scriptData = EBCLIScriptAssembly.loadScript(cmd);
                    sb.append("// from CLI as ").append(cmd).append("\n");
                    sb.append(scriptData);
                    break;
                }
                case start: 
                case run: {
                    ActivityDef activityDef = ActivityDef.parseActivityDef((String)cmd.cmdSpec);
                    sb.append("// from CLI as ").append(cmd).append("\n").append("scenario.").append(cmd.cmdType.toString()).append("(\"").append(cmd.cmdSpec).append("\");\n");
                    break;
                }
                case await: {
                    sb.append("// from CLI as ").append(cmd).append("\n");
                    sb.append("scenario.awaitActivity(\"").append(cmd.cmdSpec).append("\");\n");
                    break;
                }
                case stop: {
                    sb.append("// from CLI as ").append(cmd).append("\n");
                    sb.append("scenario.stop(\"").append(cmd.cmdSpec).append("\");\n");
                    break;
                }
                case waitmillis: {
                    sb.append("// from CLI as ").append(cmd).append("\n");
                    sb.append("scenario.waitMillis(").append(cmd.cmdSpec).append(");\n");
                }
            }
        }
        return sb.toString();
    }

    private static String loadScript(EBCLIOptions.Cmd cmd) {
        String scriptData;
        try {
            logger.debug("Looking for " + new File(".").getCanonicalPath() + File.separator + cmd.cmdSpec);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        InputStream resourceAsStream = EngineBlockFiles.findRequiredStreamOrFile((String)cmd.cmdSpec, (String)"js", (String[])new String[]{"scripts"});
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(resourceAsStream));){
            scriptData = buffer.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to buffer " + cmd.cmdSpec + ": " + t);
        }
        StrInterpolater interpolater = new StrInterpolater(cmd.getCmdArgs());
        scriptData = interpolater.apply(scriptData);
        return scriptData;
    }
}

