/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.cli;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.AbstractMatcherFilter;
import ch.qos.logback.core.spi.FilterReply;
import org.slf4j.LoggerFactory;

public class ConsoleLogging {
    public static void enableConsoleLogging(Level level, String loggingPattern) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ConsoleAppender ca = new ConsoleAppender();
        ca.setContext((Context)loggerContext);
        PatternLayoutEncoder ple = new PatternLayoutEncoder();
        ple.setPattern(loggingPattern);
        ple.setContext((Context)loggerContext);
        ple.start();
        ca.setEncoder((Encoder)ple);
        LevelFilter levelFilter = new LevelFilter(level);
        levelFilter.start();
        ca.addFilter(levelFilter);
        ca.start();
        Logger root = loggerContext.getLogger("ROOT");
        root.addAppender((Appender)ca);
        root.setLevel(Level.TRACE);
    }

    private static class LevelFilter<E>
    extends AbstractMatcherFilter<E> {
        private final Level filterLevel;

        public LevelFilter(Level filterLevel) {
            this.filterLevel = filterLevel;
        }

        public FilterReply decide(Object event) {
            if (!this.isStarted()) {
                return FilterReply.NEUTRAL;
            }
            LoggingEvent loggingEvent = (LoggingEvent)event;
            if (((LoggingEvent)event).getLevel().isGreaterOrEqual(this.filterLevel)) {
                return FilterReply.ACCEPT;
            }
            return FilterReply.DENY;
        }
    }
}

