/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.cli;

import io.engineblock.activityimpl.ActivityDef;
import io.engineblock.cli.EBCLIOptions;
import io.engineblock.util.EngineBlockFiles;
import io.engineblock.util.StrInterpolater;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EBCLIScriptAssembly {
    private static final Logger logger = LoggerFactory.getLogger(EBCLIScriptAssembly.class);

    public static ScriptData assembleScript(EBCLIOptions options) {
        StringBuilder sb = new StringBuilder();
        Map<String, String> params = new HashMap<String, String>();
        for (EBCLIOptions.Cmd cmd : options.getCommands()) {
            String cmdSpec = cmd.getCmdSpec();
            EBCLIOptions.CmdType cmdType = cmd.getCmdType();
            switch (cmd.getCmdType()) {
                case script: {
                    sb.append("// from CLI as ").append(cmd).append("\n");
                    ScriptData scriptData = EBCLIScriptAssembly.loadScript(cmd);
                    if (options.getCommands().size() == 1) {
                        sb.append(scriptData.getScriptTextIgnoringParams());
                        params = scriptData.getScriptParams();
                        break;
                    }
                    sb.append(scriptData.getScriptParamsAndText());
                    break;
                }
                case fragment: {
                    sb.append("// from CLI as ").append(cmd).append("\n");
                    sb.append(cmd.getCmdSpec());
                    if (cmdSpec.endsWith("\n")) break;
                    sb.append("\n");
                    break;
                }
                case start: 
                case run: {
                    ActivityDef activityDef = ActivityDef.parseActivityDef((String)cmdSpec);
                    sb.append("// from CLI as ").append(cmd).append("\n").append("scenario.").append(cmdType.toString()).append("(\"").append(cmdSpec).append("\");\n");
                    break;
                }
                case await: {
                    sb.append("// from CLI as ").append(cmd).append("\n");
                    sb.append("scenario.awaitActivity(\"").append(cmdSpec).append("\");\n");
                    break;
                }
                case stop: {
                    sb.append("// from CLI as ").append(cmd).append("\n");
                    sb.append("scenario.succeed(\"").append(cmdSpec).append("\");\n");
                    break;
                }
                case waitmillis: {
                    sb.append("// from CLI as ").append(cmd).append("\n");
                    sb.append("scenario.waitMillis(").append(cmdSpec).append(");\n");
                }
            }
        }
        return new ScriptData(sb.toString(), params);
    }

    private static ScriptData loadScript(EBCLIOptions.Cmd cmd) {
        String scriptData;
        try {
            logger.debug("Looking for " + new File(".").getCanonicalPath() + File.separator + cmd.getCmdSpec());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        InputStream resourceAsStream = EngineBlockFiles.findRequiredStreamOrFile((String)cmd.getCmdSpec(), (String)"js", (String[])new String[]{"scripts"});
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(resourceAsStream));){
            scriptData = buffer.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to buffer " + cmd.getCmdSpec() + ": " + t);
        }
        StrInterpolater interpolater = new StrInterpolater(cmd.getCmdArgs());
        scriptData = interpolater.apply(scriptData);
        return new ScriptData(scriptData, cmd.getCmdArgs());
    }

    private static String toJSON(Map<?, ?> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("params={\n");
        map.forEach((k, v) -> sb.append(" '").append(k.toString()).append("': '").append(v.toString()).append("',\n"));
        sb.setLength(sb.length() - 2);
        sb.append("\n};\n");
        return sb.toString();
    }

    public static class ScriptData {
        private final String scriptText;
        private final Map<String, String> scriptParams;

        public ScriptData(String scriptText, Map<String, String> scriptParams) {
            this.scriptText = scriptText;
            this.scriptParams = scriptParams;
        }

        public String getScriptTextIgnoringParams() {
            return this.scriptText;
        }

        public Map<String, String> getScriptParams() {
            return this.scriptParams;
        }

        public String getScriptParamsAndText() {
            return "// params:\n" + EBCLIScriptAssembly.toJSON(this.scriptParams) + "\n// script:\n" + this.scriptText;
        }
    }
}

