/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activities.diag;

import io.engineblock.activities.diag.DiagActivity;
import io.engineblock.activityapi.Action;
import io.engineblock.activityapi.ActivityDefObserver;
import io.engineblock.activityimpl.ActivityDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagAction
implements Action,
ActivityDefObserver {
    private static final Logger logger = LoggerFactory.getLogger(DiagAction.class);
    private final ActivityDef activityDef;
    private final DiagActivity diagActivity;
    private int slot;
    private long lastUpdate;
    private long quantizedInterval;
    private long reportModulo;

    public DiagAction(int slot, ActivityDef activityDef, DiagActivity diagActivity) {
        this.activityDef = activityDef;
        this.slot = slot;
        this.diagActivity = diagActivity;
        this.updateReportTime();
    }

    @Override
    public void accept(long value) {
        long now = System.currentTimeMillis();
        if (now - this.lastUpdate > this.quantizedInterval) {
            long delay = now - this.lastUpdate - this.quantizedInterval;
            logger.info("diag action interval, input=" + value + ", report delay=" + delay);
            this.lastUpdate += this.quantizedInterval;
            this.diagActivity.delayHistogram.update(delay);
        }
        if (value % this.reportModulo == 0L) {
            logger.info("diag action   modulo, input=" + value);
        }
    }

    private void updateReportTime() {
        this.reportModulo = this.activityDef.getParams().getLongOrDefault("modulo", 10000000L);
        this.lastUpdate = System.currentTimeMillis() - this.calculateOffset(this.slot, this.activityDef);
        this.quantizedInterval = this.calculateInterval(this.activityDef);
        logger.trace("updating report time for slot:" + this.slot + ", def:" + this.activityDef + " to " + this.quantizedInterval + ", and modulo " + this.reportModulo);
    }

    private long calculateOffset(long timeslot, ActivityDef activityDef) {
        long updateInterval = activityDef.getParams().getLongOrDefault("interval", 1000L);
        long offset = this.calculateInterval(activityDef) - updateInterval * timeslot;
        return offset;
    }

    private long calculateInterval(ActivityDef activityDef) {
        long updateInterval = activityDef.getParams().getLongOrDefault("interval", 1000L);
        if (updateInterval == 0L) {
            return Long.MAX_VALUE;
        }
        int threads = activityDef.getThreads();
        return updateInterval * (long)threads;
    }

    @Override
    public void onActivityDefUpdate(ActivityDef activityDef) {
        this.updateReportTime();
    }
}

