/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.activityimpl.input;

import io.engineblock.activityapi.ActivitiesAware;
import io.engineblock.activityapi.Activity;
import io.engineblock.activityapi.ActivityDefObserver;
import io.engineblock.activityapi.Input;
import io.engineblock.activityapi.InputDispenser;
import io.engineblock.activityimpl.input.LinkedInput;
import io.engineblock.activityimpl.input.TargetRateInput;
import java.util.Map;

public class CoreInputDispenser
implements InputDispenser,
ActivitiesAware {
    private Activity activity;
    private Map<String, Activity> activities;
    private Input input;

    public CoreInputDispenser(Activity activity) {
        this.activity = activity;
    }

    @Override
    public Input getInput(long slot) {
        if (this.input == null) {
            this.input = this.createInput(slot);
        }
        return this.input;
    }

    private synchronized Input createInput(long slot) {
        String linkinput = this.activity.getParams().getStringOrDefault("linkinput", "");
        ActivityDefObserver input = null;
        if (linkinput.isEmpty()) {
            input = new TargetRateInput(this.activity.getActivityDef());
        } else {
            Activity linkedActivity = this.activities.get(linkinput);
            if (linkedActivity == null) {
                throw new RuntimeException("To link input of activity " + this.activity.getAlias() + " to the input of " + linkinput + ", it first has to exist. Create non-linked activities first.");
            }
            input = new LinkedInput(this.activity.getActivityDef(), linkedActivity.getInputDispenser().getInput(slot));
        }
        return input;
    }

    @Override
    public void setActivitiesMap(Map<String, Activity> activities) {
        this.activities = activities;
    }
}

