/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.extensions.csvmetrics;

import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import io.engineblock.extensions.csvmetrics.MetricInstanceFilter;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class CSVMetrics {
    private final MetricRegistry registry;
    private final File reportTo;
    CsvReporter reporter;
    private MetricInstanceFilter filter = new MetricInstanceFilter();

    public CSVMetrics(String directory, Logger logger, MetricRegistry registry) {
        File reportTo = new File(directory);
        if (!reportTo.exists() && !reportTo.mkdirs()) {
            throw new RuntimeException("Unable to make directory: " + reportTo);
        }
        this.reportTo = reportTo;
        this.registry = registry;
    }

    private void initReporter() {
        if (this.reporter != null) {
            return;
        }
        this.reporter = CsvReporter.forRegistry(this.registry).convertDurationsTo(TimeUnit.MILLISECONDS).convertRatesTo(TimeUnit.SECONDS).filter(this.filter).build(this.reportTo);
    }

    public CSVMetrics(String csvFile, Logger logger, MetricRegistry registry, long period, TimeUnit timeUnit) {
        this(csvFile, logger, registry);
        this.reporter.start(period, timeUnit);
    }

    public void start(long period, String timeUnitName) {
        this.initReporter();
        TimeUnit timeUnit = TimeUnit.valueOf(timeUnitName);
        this.reporter.start(period, timeUnit);
    }

    public void add(Metric metric) {
        this.filter.add(metric);
    }

    public void stop() {
        this.reporter.stop();
    }

    public void report() {
        this.initReporter();
        this.reporter.report();
    }
}

