/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.metrics;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Locale;
import org.HdrHistogram.Histogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoStatsCSVWriter {
    private static final Logger logger = LoggerFactory.getLogger(HistoStatsCSVWriter.class);
    private static final String logFormatVersion = "1.0";
    private final File csvfile;
    PrintStream writer;
    private long baseTime;

    public HistoStatsCSVWriter(File csvFile) {
        this.csvfile = csvFile;
        this.writer = this.initFile(csvFile);
    }

    private PrintStream initFile(File logfile) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(logfile);
            PrintStream writer = new PrintStream(logfile);
            return writer;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public void setBaseTime(long baseTime) {
        this.baseTime = baseTime;
    }

    public void outputComment(String comment) {
        this.writer.format(Locale.US, "#%s\n", comment);
    }

    public void outputLogFormatVersion() {
        this.writer.format(Locale.US, "#[Histogram log format version %s]\n", logFormatVersion);
    }

    public void outputStartTime(long startTime) {
        this.writer.format(Locale.US, "#[StartTime: %.3f (seconds since epoch), %s]\n", (double)startTime / 1000.0, new Date(startTime).toString());
        this.writer.flush();
    }

    public void outputLegend() {
        this.writer.format(Locale.US, "#Tag,Interval_Start,Interval_Length,count,min,p25,p50,p75,p90,p95,p98,p99,p999,p9999,max\n", new Object[0]);
    }

    public void writeInterval(Histogram h) {
        StringBuilder csvLine = new StringBuilder(1024);
        csvLine.append("Tag=").append(h.getTag()).append(",");
        Double start = ((double)h.getStartTimeStamp() - (double)this.baseTime) / 1000.0;
        Double end = ((double)h.getEndTimeStamp() - (double)this.baseTime) / 1000.0;
        String len = String.format(Locale.US, "%.3f", end - start);
        csvLine.append(start);
        csvLine.append(",").append(len);
        csvLine.append(",").append(h.getTotalCount());
        csvLine.append(",").append(h.getMinValue());
        csvLine.append(",").append(h.getValueAtPercentile(0.25));
        csvLine.append(",").append(h.getValueAtPercentile(0.5));
        csvLine.append(",").append(h.getValueAtPercentile(0.75));
        csvLine.append(",").append(h.getValueAtPercentile(0.9));
        csvLine.append(",").append(h.getValueAtPercentile(0.95));
        csvLine.append(",").append(h.getValueAtPercentile(0.98));
        csvLine.append(",").append(h.getValueAtPercentile(0.99));
        csvLine.append(",").append(h.getValueAtPercentile(0.999));
        csvLine.append(",").append(h.getValueAtPercentile(0.9999));
        csvLine.append(",").append(h.getMaxValue());
        this.writer.println(csvLine.toString());
    }
}

