/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.metrics;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PeriodicRunnable<T extends Runnable>
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(PeriodicRunnable.class);
    private long intervalMillis;
    private T action;

    public PeriodicRunnable(long intervalMillis, T action) {
        this.action = action;
        this.intervalMillis = intervalMillis;
    }

    public void startThread() {
        Thread intervalThread = new Thread(this);
        intervalThread.setDaemon(true);
        intervalThread.setName(this.action.toString());
        intervalThread.start();
    }

    @Override
    public void run() {
        long nextEventTime = System.currentTimeMillis() + this.intervalMillis;
        while (true) {
            nextEventTime = this.awaitTime(this.intervalMillis, nextEventTime);
            logger.trace("invoking interval runnable " + this.action);
            this.action.run();
        }
    }

    private long awaitTime(long interval, long nextEventTime) {
        long duration = nextEventTime - System.currentTimeMillis();
        while (System.currentTimeMillis() < nextEventTime) {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException interruptedException) {}
        }
        return nextEventTime + interval;
    }
}

