/*
 * Decompiled with CFR 0.152.
 */
package io.engineblock.metrics;

import io.engineblock.metrics.CapabilityHook;
import io.engineblock.metrics.HdrDeltaHistogramAttachment;
import io.engineblock.metrics.HdrDeltaHistogramProvider;
import io.engineblock.metrics.HistoStatsCSVWriter;
import io.engineblock.metrics.PeriodicRunnable;
import java.io.File;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.HdrHistogram.Histogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsIntervalLogger
extends CapabilityHook<HdrDeltaHistogramAttachment>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(StatsIntervalLogger.class);
    private final String sessionName;
    private long intervalLength;
    private File logfile;
    private HistoStatsCSVWriter writer;
    private Pattern pattern;
    private List<WriterTarget> targets = new CopyOnWriteArrayList<WriterTarget>();
    private PeriodicRunnable<StatsIntervalLogger> executor;

    public StatsIntervalLogger(String sessionName, File file, Pattern pattern, long intervalLength) {
        this.sessionName = sessionName;
        this.logfile = file;
        this.pattern = pattern;
        this.intervalLength = intervalLength;
        this.startLogging();
    }

    public boolean matches(String metricName) {
        return this.pattern.matcher(metricName).matches();
    }

    public void startLogging() {
        this.writer = new HistoStatsCSVWriter(this.logfile);
        this.writer.outputComment("logging stats for session " + this.sessionName);
        this.writer.outputLogFormatVersion();
        long currentTimeMillis = System.currentTimeMillis();
        this.writer.outputStartTime(currentTimeMillis);
        this.writer.setBaseTime(currentTimeMillis);
        this.writer.outputLegend();
        this.executor = new PeriodicRunnable<StatsIntervalLogger>(this.getInterval(), this);
        this.executor.startThread();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HistoLogger:" + this.pattern + ":" + this.logfile.getPath() + ":" + this.intervalLength);
        return sb.toString();
    }

    public long getInterval() {
        return this.intervalLength;
    }

    @Override
    public void onCapableAdded(String name, HdrDeltaHistogramAttachment chainedHistogram) {
        if (this.pattern.matcher(name).matches()) {
            this.targets.add(new WriterTarget(name, chainedHistogram.attach()));
        }
    }

    @Override
    public void onCapableRemoved(String name, HdrDeltaHistogramAttachment capable) {
        this.targets.remove(new WriterTarget(name, null));
    }

    @Override
    protected Class<HdrDeltaHistogramAttachment> getCapabilityClass() {
        return HdrDeltaHistogramAttachment.class;
    }

    @Override
    public void run() {
        for (WriterTarget target : this.targets) {
            Histogram nextHdrHistogram = target.histoProvider.getNextHdrDeltaHistogram();
            this.writer.writeInterval(nextHdrHistogram);
        }
    }

    private static class WriterTarget
    implements Comparable<WriterTarget> {
        public String name;
        public HdrDeltaHistogramProvider histoProvider;

        public WriterTarget(String name, HdrDeltaHistogramProvider attach) {
            this.name = name;
            this.histoProvider = attach;
        }

        public boolean equals(Object obj) {
            return this.name.equals(((WriterTarget)obj).name);
        }

        @Override
        public int compareTo(WriterTarget obj) {
            return this.name.compareTo(obj.name);
        }
    }
}

