/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql;

import io.evitadb.externalApi.event.ReadinessEvent;
import io.evitadb.externalApi.graphql.GraphQLManager;
import io.evitadb.externalApi.graphql.configuration.GraphQLConfig;
import io.evitadb.externalApi.http.ExternalApiProvider;
import io.evitadb.utils.NetworkUtils;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLProvider
implements ExternalApiProvider<GraphQLConfig> {
    private static final Logger log = LoggerFactory.getLogger(GraphQLProvider.class);
    public static final String CODE = "graphQL";
    @Nonnull
    private final GraphQLConfig configuration;
    @Nonnull
    private final GraphQLManager graphQLManager;
    private final long requestTimeout;
    private String reachableUrl;

    public GraphQLProvider(@Nonnull GraphQLConfig configuration, @Nonnull GraphQLManager graphQLManager, long requestTimeoutInMillis) {
        this.configuration = configuration;
        this.graphQLManager = graphQLManager;
        this.requestTimeout = requestTimeoutInMillis;
    }

    @Nonnull
    public String getCode() {
        return CODE;
    }

    @Nonnull
    public ExternalApiProvider.HttpServiceDefinition[] getHttpServiceDefinitions() {
        return new ExternalApiProvider.HttpServiceDefinition[]{new ExternalApiProvider.HttpServiceDefinition(this.graphQLManager.getGraphQLRouter(), ExternalApiProvider.PathHandlingMode.DYNAMIC_PATH_HANDLING)};
    }

    public void afterAllInitialized() {
        this.graphQLManager.emitObservabilityEvents();
    }

    public boolean isReady() {
        Predicate<String> isReady = url -> {
            ReadinessEvent readinessEvent = new ReadinessEvent(CODE, ReadinessEvent.Prospective.CLIENT);
            Optional post = NetworkUtils.fetchContent((String)url, (String)"POST", (String)"application/json", (String)"{\"query\":\"{liveness}\"}", (long)this.requestTimeout, error -> {
                log.error("Error while checking readiness of GraphQL API: {}", error);
                readinessEvent.finish(ReadinessEvent.Result.ERROR);
            }, timeouted -> {
                log.error("{}", timeouted);
                readinessEvent.finish(ReadinessEvent.Result.TIMEOUT);
            });
            Boolean result = post.map(content -> content.contains("true")).orElse(false);
            if (result.booleanValue()) {
                readinessEvent.finish(ReadinessEvent.Result.READY);
            }
            return result;
        };
        String[] baseUrls = this.configuration.getBaseUrls();
        if (this.reachableUrl == null) {
            for (String baseUrl : baseUrls) {
                String url2 = baseUrl + "system";
                if (!isReady.test(url2)) continue;
                this.reachableUrl = url2;
                return true;
            }
            return false;
        }
        return isReady.test(this.reachableUrl);
    }

    @Nonnull
    public GraphQLConfig getConfiguration() {
        return this.configuration;
    }
}

